<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogsByParams(array $params)
 * @method listByParams(array $params)
 */
class CouponCreateLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取列表[分页]
     *
     * @support  array $ids 记录ids [Original type array&lt;int&gt;] 
     * @support  array $channel 渠道号 [Original type array&lt;int&gt;] 
     * @support  string $apply_in 应用于 
     * @support  string $type 模板类型 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含模板息 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLogs (int $page = 1, int $page_size = 10) {
        return self::getClass()->getLogs([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids 记录ids [Original type array&lt;int&gt;] 
     * @support  array $channel 渠道号 [Original type array&lt;int&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\CouponCreateLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\CouponCreateLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}