<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method giveByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method confirmGiveByParams(array $params)
 * @method cancelGiveByParams(array $params)
 * @method receiveByParams(array $params)
 */
class GiftCardGive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getList
     *
     * @support  array $card_ids  
     * @support  string $status  
     * @support  int $give_user_id  
     * @support  int $receive_user_id  
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 赠送
     *
     * @support  int $give_user_id 赠送人用户ID [ require true ]
     * @support  int $gift_card_id 要送的礼品卡ID [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function give () {
        return self::getClass()->give();
    }

    /**
     * 获取礼品卡赠送记录详情
     *
     * @param  int $id 赠送记录ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 确认赠送
     *
     * @param  int $id 赠送记录ID [ require true ]
     * @param  string $title 赠送标题 [ require true ]
     * @param  string $words 赠送语 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmGive (int $id, string $title, string $words = '') {
        return self::getClass()->confirmGive([
            "id" => $id,
            "title" => $title,
            "words" => $words,
        ]);
    }

    /**
     * 取消赠送
     *
     * @param  int $id 赠送记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelGive (int $id) {
        return self::getClass()->cancelGive([
            "id" => $id,
        ]);
    }

    /**
     * 领取礼品卡
     *
     * @param  int $id 赠送记录ID [ require true ]
     * @param  int $receive_user_id 领取人用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receive (int $id, int $receive_user_id) {
        return self::getClass()->receive([
            "id" => $id,
            "receive_user_id" => $receive_user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCard\GiftCardGive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCard\GiftCardGive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}