<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getStocksByParams(array $params)
 * @method getStockProductsByParams(array $params)
 * @method infoByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 调配
     *
     * @param  array $card_ids 礼品卡ids [Original type array&lt;int&gt;] [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  array $extend 扩展信息[&#039;operator_id&#039; =&gt; 1] [ require true ]
     * @param  string $type 卡类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $card_ids, int $store_id, string $type, array $extend) {
        return self::getClass()->create([
            "card_ids" => $card_ids,
            "store_id" => $store_id,
            "type" => $type,
            "extend" => $extend,
        ]);
    }

    /**
     * 查询【分页】
     *
     * @param  int $operate_id 封面|产品id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @support  bool $filter_zero_stock 过滤零库存数据 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示的数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStocks (string $type, int $operate_id = 0, int $store_id = 0, int $page = 1, int $page_size = 10) {
        return self::getClass()->getStocks([
            "type" => $type,
            "operate_id" => $operate_id,
            "store_id" => $store_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取库存记录列表
     *
     * @support  array $ids 库存ids 
     * @support  int $id 库存id 
     * @support  int $store_id 门店ID 
     * @support  bool $with_card_info 获取卡信息 
     * @param  string $type 类型 [ require true ]
     * @support  int $stock_operate_id 库存operate_id（产品卡：产品卡模板ID，礼品卡：礼品卡封面ID 
     * @support  int $stock_money 礼品卡库存的金额（该查询条件仅适用于礼品卡库存。礼品卡的库存记录里有金额，礼品卡以封面ID和面值区别库存记录） 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockProducts (string $type, int $page = 1, int $page_size = 10) {
        return self::getClass()->getStockProducts([
            "type" => $type,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取库存记录详情
     *
     * @support  int $id 库存id 
     * @support  bool $with_card_info 获取卡信息 
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (string $type) {
        return self::getClass()->info([
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}