<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getTemplatesByParams(array $params)
 * @method listByParams(array $params)
 * @method infoByParams(array $params)
 */
class ProductCardTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 优惠名称 [ require true ]
     * @param  array $limit 优惠限制 [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @param  bool $special 限时优惠 [ require true ]
     * @param  bool $action_scope 升级体验 [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, string $apply_in, array $limit, int $create_by, bool $special = false, bool $action_scope = false, array $extend = []) {
        return self::getClass()->create([
            "name" => $name,
            "apply_in" => $apply_in,
            "limit" => $limit,
            "create_by" => $create_by,
            "special" => $special,
            "action_scope" => $action_scope,
            "extend" => $extend,
        ]);
    }

    /**
     * 更新模板
     *
     * @param  int $id 模板id [Original type uint] [ require true ]
     * @support  string $name 优惠名称 
     * @support  array $limit 优惠限制 
     * @support  bool $special 限时优惠 
     * @support  bool $action_scope 升级体验 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 模板列表-分页
     *
     * @support  array $ids 模板ids [Original type array&lt;int&gt;] 
     * @support  string $name 模板名称 
     * @support  string $apply_in 应用于 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplates (int $page, int $page_size) {
        return self::getClass()->getTemplates([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 模板列表
     *
     * @support  array $ids 模板ids [Original type array&lt;int&gt;] 
     * @support  string $name 模板名称 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 模板详情
     *
     * @param  int $id 模板id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\ProductCardTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\ProductCardTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}