<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method generateBatchCardsByParams(array $params)
 * @method generateActivityCardByParams(array $params)
 * @method listByParams(array $params)
 * @method getCardsByParams(array $params)
 * @method infoByParams(array $params)
 * @method delayByParams(array $params)
 * @method updateTransferOrderNumByParams(array $params)
 * @method getUserCardsByParams(array $params)
 * @method getAvailableCardsByParams(array $params)
 * @method getCardDiscountPriceByParams(array $params)
 * @method useByParams(array $params)
 * @method bindByParams(array $params)
 * @method refundByParams(array $params)
 * @method abolishCardsByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品卡生成【实体卡】
     *
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  array $extend 拓展信息[title] 
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始使用时间 
     * @support  int $validity_period 有效期 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateBatchCards () {
        return self::getClass()->generateBatchCards();
    }

    /**
     * 活动页生成优惠券
     *
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] [ require true ]
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @param  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @support  int $user_id 用户id 
     * @support  int $count 生成数量 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateActivityCard (int $template_id, int $channel, string $status, string $stop_usage) {
        return self::getClass()->generateActivityCard([
            "template_id" => $template_id,
            "channel" => $channel,
            "status" => $status,
            "stop_usage" => $stop_usage,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids 卡ids 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  array $status 状态 
     * @support  array $codes 优惠码 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 包含模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $ids 卡ids 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  array $status 状态 
     * @support  array $codes 优惠码 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 包含模板信息 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCards (int $page, int $page_size) {
        return self::getClass()->getCards([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @support  int $id 产品卡id 
     * @support  string $code 优惠code 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 产品卡延期
     *
     * @support  array $codes 优惠码 [ require true ]
     * @support  string $stop_usage 到期日期 [ require true ]
     * @support  int $operator 操作人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delay () {
        return self::getClass()->delay();
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  string $order_num 老订单号 [ require true ]
     * @param  string $new_order_num 新订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTransferOrderNum (string $order_num, string $new_order_num) {
        return self::getClass()->updateTransferOrderNum([
            "order_num" => $order_num,
            "new_order_num" => $new_order_num,
        ]);
    }

    /**
     * 获得用户产品卡
     *
     * @support  int $user_id 用户ID [Original type uint] [ require true ]
     * @support  string $status 状态 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 获取模板信息 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCards () {
        return self::getClass()->getUserCards();
    }

    /**
     * 获取用户下单使用券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  array $product_ids 产品ids [Original type array&lt;int&gt;] [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableCards (int $user_id, array $product_ids, int $store_id, string $apply_in) {
        return self::getClass()->getAvailableCards([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 获得优惠券可折扣金额
     *
     * @param  int $card_id 产品卡ID [Original type uint] [ require true ]
     * @param  array $node_info 产品详情 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardDiscountPrice (int $card_id, array $node_info) {
        return self::getClass()->getCardDiscountPrice([
            "card_id" => $card_id,
            "node_info" => $node_info,
        ]);
    }

    /**
     * 使用产品卡
     *
     * @param  int $id 产品卡id [Original type uint] [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function use (int $user_id, int $id, string $order_num) {
        return self::getClass()->use([
            "user_id" => $user_id,
            "id" => $id,
            "order_num" => $order_num,
        ]);
    }

    /**
     * 产品卡绑定
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind (int $user_id, string $code) {
        return self::getClass()->bind([
            "user_id" => $user_id,
            "code" => $code,
        ]);
    }

    /**
     * 退款返回产品卡
     *
     * @param  int $id 产品卡id [Original type uint] [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund (int $id, int $user_id) {
        return self::getClass()->refund([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 作废产品卡
     *
     * @param  array $codes 卡ids [Original type array&lt;string&gt;] [ require true ]
     * @support  int $operator 操作人 [Original type uint] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishCards (array $codes) {
        return self::getClass()->abolishCards([
            "codes" => $codes,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}