<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method getTemplatesByParams(array $params)
 * @method infoByParams(array $params)
 */
class CouponTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建模板
     *
     * @param  string $name 优惠名称 [ require true ]
     * @param  string $type 优惠类型 [ require true ]
     * @param  array $limit 优惠限制 [ require true ]
     * @param  float $discount 折扣 [Original type double] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @support  bool $special 限时优惠 
     * @support  bool $action_scope 升级体验 
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, string $type, string $apply_in, array $limit, int $create_by, float $discount) {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
            "apply_in" => $apply_in,
            "limit" => $limit,
            "create_by" => $create_by,
            "discount" => $discount,
        ]);
    }

    /**
     * 更新模板
     *
     * @param  int $id 模板id [Original type uint] [ require true ]
     * @support  string $name 优惠名称 
     * @support  array $limit 优惠限制 
     * @support  float $discount 折扣 [Original type double] 
     * @support  bool $special 限时优惠 
     * @support  bool $action_scope 升级体验 
     * @support  array $extend 拓展信息 
     * @support  int $operator 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 模板名称 
     * @support  string $type 优惠类型 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  string $name 优惠名称 
     * @support  string $type 优惠类型 
     * @support  string $apply_in 应用于 
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplates (int $page = 1, int $page_size = 10) {
        return self::getClass()->getTemplates([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 模板详情
     *
     * @param  int $id 模板id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\CouponTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\CouponTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}