<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getCouponDiscountPriceByParams(array $params)
 * @method listByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method abolishByParams(array $params)
 * @method delayByParams(array $params)
 * @method useByParams(array $params)
 */
class InteriorCoupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  int $count 创建数量 [Original type uint] [ require true ]
     * @param  float $per_money 单个金额 [Original type double] [ require true ]
     * @support  float $pay_money 实付金额 [Original type double] 
     * @support  int $store_id 门店id [Original type uint] 
     * @param  string $buy_channel 购买渠道 [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  string $stop_usage 过期时间 [ require true ]
     * @support  array $extend 拓展信息[包含备注信息] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $create_by, int $count, float $per_money, string $stop_usage, string $buy_channel) {
        return self::getClass()->create([
            "create_by" => $create_by,
            "count" => $count,
            "per_money" => $per_money,
            "stop_usage" => $stop_usage,
            "buy_channel" => $buy_channel,
        ]);
    }

    /**
     * 获取优惠码折扣
     *
     * @param  string $uuid 优惠码 [ require true ]
     * @param  bool $verify_usability 验证可用性 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponDiscountPrice (string $uuid, bool $verify_usability = false) {
        return self::getClass()->getCouponDiscountPrice([
            "uuid" => $uuid,
            "verify_usability" => $verify_usability,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  int $create_log_id 记录id 
     * @support  array $uuids 内部折扣uuids [Original type array&lt;string&gt;] 
     * @support  array $status 状态 [Original type array&lt;string&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取列表-分页
     *
     * @support  array $uuids uuids [Original type array&lt;string&gt;] 
     * @support  int $create_log_id 记录id 
     * @support  array $status 状态 [Original type array&lt;string&gt;] 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoupons (int $page = 1, int $page_size = 10) {
        return self::getClass()->getCoupons([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 折扣码id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 内部折扣码更新
     *
     * @param  array $uuids uuids [Original type array&lt;string&gt;] [ require true ]
     * @param  int $operator 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolish (array $uuids, int $operator) {
        return self::getClass()->abolish([
            "uuids" => $uuids,
            "operator" => $operator,
        ]);
    }

    /**
     * 优惠券延期
     *
     * @support  array $uuids uuids [Original type array&lt;string&gt;] [ require true ]
     * @support  string $stop_usage 到期日期 [ require true ]
     * @support  int $operator 操作人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delay () {
        return self::getClass()->delay();
    }

    /**
     * 使用开单折扣码
     *
     * @param  string $uuid uuid [ require true ]
     * @param  float $money 抵扣金额 [Original type double] [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $store_id 使用门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function use (string $order_num, string $uuid, float $money, int $store_id) {
        return self::getClass()->use([
            "order_num" => $order_num,
            "uuid" => $uuid,
            "money" => $money,
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Coupon\InteriorCoupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Coupon\InteriorCoupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}