<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPayTypesByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method userCreateByParams(array $params)
 * @method managerCreateByParams(array $params)
 * @method afterPayByParams(array $params)
 * @method updateInvoiceIdByParams(array $params)
 */
class GiftCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡订单支付类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPayTypes () {
        return self::getClass()->getPayTypes();
    }

    /**
     * 获取列表
     *
     * @support  string $order_num 订单号 
     * @support  int $store_id 门店id [Original type uint] 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $type 订单类型 
     * @support  bool $with_items 是否需要明细信息 
     * @support  array $card_ids 卡ids 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取列表-分页
     *
     * @support  int $store_id 门店id [Original type uint] 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $user_name 用户名 
     * @support  array $order_nums 订单号 
     * @support  string $phone 手机号 
     * @support  string $type 订单类型 
     * @support  string $start_at 支付开始时间 
     * @support  string $end_at 支付结束时间 
     * @support  string $pay_type 支付类型 
     * @support  bool $with_items 是否需要明细信息 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 页码 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  bool $with_items 是否需要明细信息 [ require true ]
     * @param  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $order_id = 0, string $order_num = '', bool $with_items = false, int $refund_id = 0) {
        return self::getClass()->getInfo([
            "order_id" => $order_id,
            "order_num" => $order_num,
            "with_items" => $with_items,
            "refund_id" => $refund_id,
        ]);
    }

    /**
     * 用户购买礼品卡
     *
     * @support  string $sex 性别 
     * @param  string $phone 手机号 [ require true ]
     * @support  array $extend 拓展信息 
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @support  string $user_name 用户名 
     * @param  float $pay_money 实付 [Original type double] [ require true ]
     * @param  array $card_item 卡片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userCreate (int $user_id, float $pay_money, array $card_item, string $phone) {
        return self::getClass()->userCreate([
            "user_id" => $user_id,
            "pay_money" => $pay_money,
            "card_item" => $card_item,
            "phone" => $phone,
        ]);
    }

    /**
     * 管理端售卖礼品卡
     *
     * @support  string $sex 性别 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @support  array $extend 拓展信息 
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  array $card_ids 卡片ids [Original type array&lt;uint&gt;] [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @support  string $user_name 用户名 [ require true ]
     * @param  float $pay_money 实付 [Original type double] [ require true ]
     * @param  int $create_by 录单人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function managerCreate (string $phone, string $pay_type, float $pay_money, array $card_ids, int $create_by, int $user_id, int $store_id) {
        return self::getClass()->managerCreate([
            "phone" => $phone,
            "pay_type" => $pay_type,
            "pay_money" => $pay_money,
            "card_ids" => $card_ids,
            "create_by" => $create_by,
            "user_id" => $user_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 设计给预约端购买礼品卡使用
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no = NULL) {
        return self::getClass()->afterPay([
            "order_id" => $order_id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 修改发票信息
     *
     * @param  int $invoice_id 发票id [Original type uint] [ require true ]
     * @param  array $order_nums 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return self::getClass()->updateInvoiceId([
            "order_nums" => $order_nums,
            "invoice_id" => $invoice_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}