<?php
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method infoByParams(array $params)
 * @method getAvailableCardsByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端生成优惠券
     *
     * @param  string $title 标题 [ require true ]
     * @param  string $status 优惠券状态[激活：unused] [ require true ]
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  int $count 创建数量 [Original type uint] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  float $pay_money 收金额 [Original type unsignedDouble] 
     * @param  string $buy_channel 购买渠道 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始使用时间 
     * @support  int $validity_period 有效期 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $title, int $template_id, int $create_by, int $count, string $buy_channel, string $status) {
        return self::getClass()->create([
            "title" => $title,
            "template_id" => $template_id,
            "create_by" => $create_by,
            "count" => $count,
            "buy_channel" => $buy_channel,
            "status" => $status,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  array $ids 卡ids 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  array $status 状态 
     * @support  array $codes 优惠码 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 包含模板信息 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCoupons (int $page, int $page_size) {
        return self::getClass()->getCoupons([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @param  int $id 产品卡id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 获取用户下单使用券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  array $product_ids 产品ids [Original type array&lt;int&gt;] [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableCards (int $user_id, array $product_ids, int $store_id, string $apply_in) {
        return self::getClass()->getAvailableCards([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}