<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method withdrawByParams(array $params)
 */
class GiftCardWithdraw {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 注意：目前只有礼品卡转退（钱退款至礼品卡）一种场景支持提现，所以出于安全考虑，在这里做了限制，邀请必须有退款至新礼品卡的记录！！！
     * 后期如果完善礼品卡提现业务，可以对此进行重构
     *
     * @param  int $card_id 礼品卡ID [ require true ]
     * @param  float $money 提现金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function withdraw (int $card_id, float $money) {
        return self::getClass()->withdraw([
            "card_id" => $card_id,
            "money" => $money,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCardWithdraw');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCardWithdraw');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}