<?php
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class GiftCardCover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @support  string $title 卡面标题 [ require true ]
     * @support  string $img_path 卡面图片地址 [ require true ]
     * @support  int $sequence 排序值 [Original type uint] 
     * @param  int $topic_id 主题id [Original type uint] [ require true ]
     * @support  bool $is_on_sale 是否在售 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $topic_id) {
        return self::getClass()->create([
            "topic_id" => $topic_id,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $title 卡面标题 
     * @support  string $img_path 卡面图片地址 
     * @support  int $sequence 排序值 [Original type uint] 
     * @support  int $topic_id 主题id [Original type uint] 
     * @support  bool $is_on_sale 是否在售 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $topic_ids 主题ids 
     * @support  array $cover_ids 卡面ids 
     * @support  string $title 卡面标题 
     * @support  bool $has_topic_info 是否包含主题信息 
     * @support  bool $is_on_sale 是否在售 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  array $topic_ids 主题ids 
     * @support  string $title 卡面标题 
     * @support  bool $has_topic_info 是否包含主题信息 
     * @support  bool $is_on_sale 是否在售 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'GiftCardCover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'GiftCardCover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}