<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createDecreaseCouponByParams(array $params)
 * @method createProductCouponByParams(array $params)
 * @method createDsRepairCouponByParams(array $params)
 * @method createDsPrintCouponByParams(array $params)
 * @method createDiscountCouponByParams(array $params)
 * @method getListByParams(array $params)
 */
class PreferentialType {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增立减券类型
     *
     * @param  float $money 立减金额 [Original type unsignedDouble] [ require true ]
     * @param  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createDecreaseCoupon (float $money, int $template_id, array $extend) {
        return self::getClass()->createDecreaseCoupon([
            "money" => $money,
            "template_id" => $template_id,
            "extend" => $extend,
        ]);
    }

    /**
     * 新增产品券类型
     *
     * @param  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createProductCoupon (int $template_id, array $extend = []) {
        return self::getClass()->createProductCoupon([
            "template_id" => $template_id,
            "extend" => $extend,
        ]);
    }

    /**
     * 新增加修券类型
     *
     * @param  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createDsRepairCoupon (int $template_id, array $extend = []) {
        return self::getClass()->createDsRepairCoupon([
            "template_id" => $template_id,
            "extend" => $extend,
        ]);
    }

    /**
     * 新增加印券类型
     *
     * @param  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createDsPrintCoupon (int $template_id, array $extend = []) {
        return self::getClass()->createDsPrintCoupon([
            "template_id" => $template_id,
            "extend" => $extend,
        ]);
    }

    /**
     * 新增折扣券类型
     *
     * @param  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @param  float $discount 折扣(0~1) [Original type unsignedDouble] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createDiscountCoupon (int $template_id, float $discount, array $extend) {
        return self::getClass()->createDiscountCoupon([
            "template_id" => $template_id,
            "discount" => $discount,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @param  float $discount 金额【目前只支持立减劵】 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $template_id = 0, float $discount = 0) {
        return self::getClass()->getList([
            "template_id" => $template_id,
            "discount" => $discount,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'PreferentialType');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'PreferentialType');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}