<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method updatePreferentialByParams(array $params)
 * @method updateTransferOrderNumByParams(array $params)
 * @method generalPreferentialByParams(array $params)
 * @method generalActivityPreferentialByParams(array $params)
 * @method getCanUseByParams(array $params)
 * @method getUserPreferentialByParams(array $params)
 * @method usePreferentialByParams(array $params)
 * @method getPreferentialSubPriceByParams(array $params)
 * @method bindPreferentialByParams(array $params)
 * @method returnUserPreferentialByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getQueryBuilderByParams(array $params)
 * @method abolishPreferentialByParams(array $params)
 */
class UserPreferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取列表
     *
     * @support  array $ids 卡ids 
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  string $code 优惠码 
     * @support  array $codes 优惠码组 
     * @support  string $type 优惠券类型 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_type_info 包含卡面信息 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $apply_in 应用于 
     * @support  array $status 状态 
     * @support  int $product_id 产品id 
     * @support  array $order_nums 订单号 
     * @support  int $template_id 模板id 
     * @support  bool $with_unique_code 是否需要unique_code 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取列表-分页
     *
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  bool $bound 是否已绑定 
     * @support  int $template_id 模板id 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  array $status 状态 
     * @support  string $code 优惠码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_type_info 包含卡面信息 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 更新优惠码状态
     *
     * @param  array $preferential_ids 优惠码ids [ require true ]
     * @param  array $codes 优惠码 [ require true ]
     * @support  int $operator 操作人 [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $stop_usage 到期日期 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePreferential (array $preferential_ids = [], array $codes = []) {
        return self::getClass()->updatePreferential([
            "preferential_ids" => $preferential_ids,
            "codes" => $codes,
        ]);
    }

    /**
     * 更新适用订单【转门店】
     *
     * @param  string $order_num 老订单号 [ require true ]
     * @param  string $new_order_num 新订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTransferOrderNum (string $order_num, string $new_order_num) {
        return self::getClass()->updateTransferOrderNum([
            "order_num" => $order_num,
            "new_order_num" => $new_order_num,
        ]);
    }

    /**
     * 管理端生成优惠券
     *
     * @param  string $title 标题 [ require true ]
     * @param  int $type_id 优惠类型id [Original type uint] [ require true ]
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  int $count 创建数量 [Original type uint] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  float $pay_money 收金额 [Original type unsignedDouble] 
     * @param  string $buy_channel 购买渠道 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始使用时间 
     * @param  string $card_init_status 优惠券状态[激活：unused] [ require true ]
     * @support  bool $active_flush_stop 是否激活后更新有效期 
     * @throws  \Exception
     * @return  mixed
     */
    public static function generalPreferential (string $title, int $type_id, int $template_id, int $create_by, int $count, string $buy_channel, string $card_init_status) {
        return self::getClass()->generalPreferential([
            "title" => $title,
            "type_id" => $type_id,
            "template_id" => $template_id,
            "create_by" => $create_by,
            "count" => $count,
            "buy_channel" => $buy_channel,
            "card_init_status" => $card_init_status,
        ]);
    }

    /**
     * 活动页生成优惠券
     *
     * @param  int $type_id 优惠类型id [Original type uint] [ require true ]
     * @param  int $template_id 模板的id [Original type uint] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] [ require true ]
     * @param  int $channel 生成渠道 [ require true ]
     * @support  array $extend 拓展信息 
     * @param  string $stop_usage 结束使用时间 [ require true ]
     * @support  string $start_usage 开始使用时间 [ require true ]
     * @param  string $status 优惠券状态[激活：unused] [ require true ]
     * @support  int $user_id 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function generalActivityPreferential (int $type_id, int $template_id, string $status, string $stop_usage, int $channel) {
        return self::getClass()->generalActivityPreferential([
            "type_id" => $type_id,
            "template_id" => $template_id,
            "status" => $status,
            "stop_usage" => $stop_usage,
            "channel" => $channel,
        ]);
    }

    /**
     * 获取用户下单可使用优惠券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanUse (int $user_id, array $product_ids, int $store_id, string $apply_in) {
        return self::getClass()->getCanUse([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
            "store_id" => $store_id,
            "apply_in" => $apply_in,
        ]);
    }

    /**
     * 获得用户优惠券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  bool $has_type_info 拥有类型信息 [ require true ]
     * @support  string $status 优惠券状态 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserPreferential (int $user_id, bool $has_type_info = false) {
        return self::getClass()->getUserPreferential([
            "user_id" => $user_id,
            "has_type_info" => $has_type_info,
        ]);
    }

    /**
     * 使用优惠券
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  int $preferential_id 优惠券id [Original type uint] [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function usePreferential (int $user_id, int $preferential_id, string $order_num) {
        return self::getClass()->usePreferential([
            "user_id" => $user_id,
            "preferential_id" => $preferential_id,
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获得优惠券可折扣金额
     *
     * @param  int $preferential_id 优惠券ID [Original type uint] [ require true ]
     * @param  array $node_info 产品价格信息[&#039;store_id&#039; =&gt; 1001, &#039;node_price&#039; =&gt; [], &#039;product_node_price&#039; =&gt; [], &#039;discount&#039; =&gt; []] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPreferentialSubPrice (int $preferential_id, array $node_info) {
        return self::getClass()->getPreferentialSubPrice([
            "preferential_id" => $preferential_id,
            "node_info" => $node_info,
        ]);
    }

    /**
     * 绑定优惠券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  string $preferential_code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindPreferential (int $user_id, string $preferential_code) {
        return self::getClass()->bindPreferential([
            "user_id" => $user_id,
            "preferential_code" => $preferential_code,
        ]);
    }

    /**
     * 返还优惠券
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  int $preferential_id 优惠券ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnUserPreferential (int $user_id, int $preferential_id) {
        return self::getClass()->returnUserPreferential([
            "user_id" => $user_id,
            "preferential_id" => $preferential_id,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $preferential_id 优惠券id [Original type uint] [ require true ]
     * @param  string $code 优惠code [ require true ]
     * @param  string $uuid 优惠uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $preferential_id = 0, string $code = '', string $uuid = '') {
        return self::getClass()->getInfo([
            "preferential_id" => $preferential_id,
            "code" => $code,
            "uuid" => $uuid,
        ]);
    }

    /**
     * getQueryBuilder
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueryBuilder () {
        return self::getClass()->getQueryBuilder();
    }

    /**
     * 作废优惠券
     *
     * @param  array $preferential_ids 券ids [Original type array&lt;int&gt;] [ require true ]
     * @param  array $codes 券ids [Original type array&lt;string&gt;] [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @support  array $extend 扩展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishPreferential (array $preferential_ids = [], int $user_id = 0, array $codes = []) {
        return self::getClass()->abolishPreferential([
            "preferential_ids" => $preferential_ids,
            "user_id" => $user_id,
            "codes" => $codes,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'UserPreferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'UserPreferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}