<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getStockListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getCardListByPageByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 入库
     *
     * @param  array $cardIds 礼品卡ids [Original type array&lt;int&gt;] [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  array $extend 扩展信息[&#039;operator_id&#039; =&gt; 1] [ require true ]
     * @param  string $type 卡类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $cardIds, int $storeId, string $type, array $extend) {
        return self::getClass()->create([
            "cardIds" => $cardIds,
            "storeId" => $storeId,
            "type" => $type,
            "extend" => $extend,
        ]);
    }

    /**
     * 查询【分页】
     *
     * @param  int $operateId 封面|产品id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @support  bool $withCoverInfo 卡面信息 
     * @param  string $type 类型 [ require true ]
     * @support  bool $filterZeroStock 过滤零库存数据 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页显示的数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockListByPage (string $type, int $operateId = 0, int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStockListByPage([
            "type" => $type,
            "operateId" => $operateId,
            "storeId" => $storeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取记录详情
     *
     * @support  int $id 库存id 
     * @support  array $ids 库存ids 
     * @support  bool $withCardInfo 获取卡信息 
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $type) {
        return self::getClass()->getInfo([
            "type" => $type,
        ]);
    }

    /**
     * 获取记录详情
     *
     * @support  int $id 库存id 
     * @support  array $ids 库存ids 
     * @support  bool $withCardInfo 获取卡信息 
     * @param  string $type 类型 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCardListByPage (string $type, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getCardListByPage([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}