<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 */
class PreferentialTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 优惠名称 [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @param  string $type 优惠类型 [ require true ]
     * @param  array $limit 优惠限制 [ require true ]
     * @param  string $apply_in 应用于 [ require true ]
     * @param  int $special 立减劵是否可用于限时优惠 [ require true ]
     * @param  int $action_scope 是否包含sku [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, string $type, string $apply_in, array $extend, array $limit, int $special = 0, int $action_scope = 0) {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
            "apply_in" => $apply_in,
            "extend" => $extend,
            "limit" => $limit,
            "special" => $special,
            "action_scope" => $action_scope,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id 优惠模板id [ require true ]
     * @support  string $name 优惠名称 
     * @support  array $extend 拓展信息 
     * @support  array $limit 优惠限制 
     * @support  string $apply_in 应用于 
     * @support  int $special 立减劵是否可用于限时优惠 
     * @support  int $action_scope 是否包含sku 
     * @throws  \Exception
     * @return  int
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 优惠模板id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  string $name 优惠名称 
     * @support  string $type 类型 
     * @support  bool $with_types 是否包含类型 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取列表-分页
     *
     * @support  string $name 优惠名称 
     * @support  string $type 类型 
     * @support  string $apply_in 应用于 
     * @support  bool $with_types 是否包含类型 
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'PreferentialTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'PreferentialTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}