<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getPreferentialPriceByParams(array $params)
 * @method usePreferentialByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class InteriorPreferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  int $count 创建数量 [Original type uint] [ require true ]
     * @param  float $each_money 单个金额 [Original type double] [ require true ]
     * @support  float $pay_money 实付金额 [Original type double] 
     * @support  int $store_id 门店id [Original type uint] 
     * @param  string $buy_channel 购买渠道 [ require true ]
     * @support  string $remark 备注 [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  array $extend 拓展信息 
     * @param  string $stop_usage 过期时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $create_by, int $count, float $each_money, string $stop_usage, string $buy_channel) {
        return self::getClass()->create([
            "create_by" => $create_by,
            "count" => $count,
            "each_money" => $each_money,
            "stop_usage" => $stop_usage,
            "buy_channel" => $buy_channel,
        ]);
    }

    /**
     * 获取优惠码折扣
     *
     * @param  string $code 优惠码 [ require true ]
     * @param  bool $validate_usability 验证可用性 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialPrice (string $code, bool $validate_usability = false) {
        return self::getClass()->getPreferentialPrice([
            "code" => $code,
            "validate_usability" => $validate_usability,
        ]);
    }

    /**
     * 使用开单折扣码
     *
     * @param  string $code 优惠码 [ require true ]
     * @param  float $money 优惠金额 [Original type double] [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function usePreferential (string $order_num, string $code, float $money) {
        return self::getClass()->usePreferential([
            "order_num" => $order_num,
            "code" => $code,
            "money" => $money,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  int $create_log_id 记录id [ require true ]
     * @param  string $uuid 内部折扣uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $create_log_id = 0, string $uuid = '') {
        return self::getClass()->getList([
            "create_log_id" => $create_log_id,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 获取列表-分页
     *
     * @support  int $create_log_id 记录id 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 折扣码id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'InteriorPreferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'InteriorPreferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}