<?php
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class ProductCardOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @param  string $user_name 用户名 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $sex 性别 [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  float $ori_money 原价金额 [Original type unsignedDouble] [ require true ]
     * @param  float $pay_money 实付金额 [Original type unsignedDouble] [ require true ]
     * @param  array $card_ids 产品卡ids [ require true ]
     * @param  int $create_by 创建人 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $store_id, string $user_name, string $phone, string $pay_type, string $sex, float $ori_money, float $pay_money, array $card_ids, int $create_by, array $extend = []) {
        return self::getClass()->create([
            "store_id" => $store_id,
            "user_name" => $user_name,
            "phone" => $phone,
            "pay_type" => $pay_type,
            "sex" => $sex,
            "ori_money" => $ori_money,
            "pay_money" => $pay_money,
            "card_ids" => $card_ids,
            "create_by" => $create_by,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $store_ids 门店ids 
     * @support  string $user_name 用户姓名 
     * @support  string $phone 手机号 
     * @support  string $pay_type 订单支付类型 
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  int $id 产品卡id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Preferential', 'ProductCardOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Preferential', 'ProductCardOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}