<?php
namespace Mainto\Bridge\Invokes\PictureOnline\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 */
class HistoricalPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片师上传修片信息
     *
     * @param  int $photo_id 照片 id [ require true ]
     * @param  string $path 照片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $photo_id, string $path) {
        return self::getClass()->create([
            "photo_id" => $photo_id,
            "path" => $path,
        ]);
    }

    /**
     * 看片师批量上传修片信息
     *
     * @param  array $photo_array 修片数组[[&#039;photo_id&#039; =&gt; 1, &#039;path&#039; =&gt; &#039;www&#039;,],[&#039;photo_id&#039; =&gt; 2, &#039;path&#039; =&gt; &#039;www2&#039;,]] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $photo_array) {
        return self::getClass()->batchCreate([
            "photo_array" => $photo_array,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Cloud\HistoricalPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Cloud\HistoricalPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}