<?php
namespace Mainto\Bridge\Invokes\PictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncStreamDataByParams(array $params)
 * @method completeShowPicOrderByParams(array $params)
 * @method reUploadCompleteByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听门店已线下完成看片
     *
     * @param  array $order 订单信息 [ require true ]
     * @param  string $stream_num 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncStreamData (array $order, string $stream_num) {
        return self::getClass()->syncStreamData([
            "order" => $order,
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 监听修修兽完成订单
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeShowPicOrder (string $orderNum) {
        return self::getClass()->completeShowPicOrder([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 监听重传完成流水
     *
     * @param  string $before_stream_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reUploadComplete (string $before_stream_num) {
        return self::getClass()->reUploadComplete([
            "before_stream_num" => $before_stream_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}