<?php
namespace Mainto\Bridge\Invokes\PictureOnline\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getWatchCountByParams(array $params)
 * @method hookByPhotoFopByParams(array $params)
 * @method satisfiedPhotoByStreamAndOriginalPathByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 流水号下所有照片
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $serial_no) {
        return self::getClass()->all([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * 删除照片
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @param  array $cloud_photo_ids 云端照片ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $serial_no, array $cloud_photo_ids) {
        return self::getClass()->delete([
            "serial_no" => $serial_no,
            "cloud_photo_ids" => $cloud_photo_ids,
        ]);
    }

    /**
     * 获取看片师看片数量
     *
     * @param  string $retoucher_no 修片师工号 [ require true ]
     * @param  string $start_time 开始时间 [ require true ]
     * @param  string $end_time 结束时间 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getWatchCount (string $retoucher_no, string $start_time, string $end_time) {
        return self::getClass()->getWatchCount([
            "retoucher_no" => $retoucher_no,
            "start_time" => $start_time,
            "end_time" => $end_time,
        ]);
    }

    /**
     * 图片裁剪回调
     *
     * @param  array $items 状态信息 [ require true ]
     * @param  string $inputKey 源文件的文件名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookByPhotoFop (array $items, string $inputKey) {
        return self::getClass()->hookByPhotoFop([
            "items" => $items,
            "inputKey" => $inputKey,
        ]);
    }

    /**
     * 根据流水号＋原片地址满意照片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  string $originalPath 原片 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function satisfiedPhotoByStreamAndOriginalPath (string $streamNum, string $originalPath) {
        return self::getClass()->satisfiedPhotoByStreamAndOriginalPath([
            "streamNum" => $streamNum,
            "originalPath" => $originalPath,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Cloud\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Cloud\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}