<?php
namespace Mainto\Bridge\Invokes\PictureOnline;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reissueTypesetedByParams(array $params)
 * @method orderConfirmEventByParams(array $params)
 * @method changeOrderRetoucherByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 补发裁剪事件
     *
     * @param  int $serialNumberId 流水id [ require true ]
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reissueTypeseted (int $serialNumberId, int $photoId) {
        return self::getClass()->reissueTypeseted([
            "serialNumberId" => $serialNumberId,
            "photoId" => $photoId,
        ]);
    }

    /**
     * 补发订单完成事件
     *
     * @param  string $serialNo 流水 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderConfirmEvent (string $serialNo) {
        return self::getClass()->orderConfirmEvent([
            "serialNo" => $serialNo,
        ]);
    }

    /**
     * 转移看片师
     *
     * @param  string $serialNo 流水 [ require true ]
     * @param  int $retoucherId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderRetoucher (string $serialNo, int $retoucherId) {
        return self::getClass()->changeOrderRetoucher([
            "serialNo" => $serialNo,
            "retoucherId" => $retoucherId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}