<?php
namespace Mainto\Bridge\Invokes\PictureOnline\SmallProgram;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tagDissatisfiedByParams(array $params)
 * @method changeToStoreByParams(array $params)
 * @method updateUserStartWaitAtByParams(array $params)
 * @method getCanDingInfoByParams(array $params)
 * @method dingStaffByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记不满意
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagDissatisfied (string $orderNum) {
        return self::getClass()->tagDissatisfied([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 转去门店看片
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeToStore (string $orderNum) {
        return self::getClass()->changeToStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 更新顾客开始等待时间点
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUserStartWaitAt (string $orderNum) {
        return self::getClass()->updateUserStartWaitAt([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取可钉状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanDingInfo (string $orderNum) {
        return self::getClass()->getCanDingInfo([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * ding看片师
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingStaff (string $orderNum) {
        return self::getClass()->dingStaff([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'SmallProgram\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'SmallProgram\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}