<?php
namespace Mainto\Bridge\Invokes\PictureOnline\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncSerialNumberInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method alreadyOfflineByParams(array $params)
 * @method takeSerialNumberByParams(array $params)
 * @method allByParams(array $params)
 * @method retoucherSerialAllByParams(array $params)
 * @method completeOrderByParams(array $params)
 * @method serialCountByParams(array $params)
 * @method getSerialStatusByParams(array $params)
 * @method generateUserSigByParams(array $params)
 * @method autoSendReduceByParams(array $params)
 * @method isOnlineOrderNumByParams(array $params)
 */
class SerialNumber {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步云图流水号信息
     *
     * @param  array $serial_data 流水号数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncSerialNumberInfo (array $serial_data) {
        return self::getClass()->syncSerialNumberInfo([
            "serial_data" => $serial_data,
        ]);
    }

    /**
     * 更新流水号相关数据
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @support  string $status 状态 
     * @support  bool $already_offline 已线下拍摄 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $serial_no) {
        return self::getClass()->update([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * 通知-已线下看片
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function alreadyOffline (string $serial_no) {
        return self::getClass()->alreadyOffline([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * 修片师接单
     *
     * @param  string $retoucher_no 看片师工号 [ require true ]
     * @param  int $retoucher_store 看片师门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeSerialNumber (string $retoucher_no, int $retoucher_store) {
        return self::getClass()->takeSerialNumber([
            "retoucher_no" => $retoucher_no,
            "retoucher_store" => $retoucher_store,
        ]);
    }

    /**
     * 获取在线接单列表
     *
     * @support  string $status 订单状态 
     * @support  string $customer_phone 顾客手机号 
     * @support  string $customer_name 顾客姓名 
     * @support  string $order_no 订单号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $page_size = 10, int $page = 1) {
        return self::getClass()->all([
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取修片师接单数据
     *
     * @support  string $retoucher_no 修片师工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function retoucherSerialAll () {
        return self::getClass()->retoucherSerialAll();
    }

    /**
     * 管理员确认完成订单
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeOrder () {
        return self::getClass()->completeOrder();
    }

    /**
     * 获取订单数量显示
     *
     * @support  string $retoucher_no 修片师工号 
     * @throws  \Exception
     * @return  array
     */
    public static function serialCount () {
        return self::getClass()->serialCount();
    }

    /**
     * 获取指定流水状态
     *
     * @support  array $serial_no 流水号数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSerialStatus () {
        return self::getClass()->getSerialStatus();
    }

    /**
     * 生成UserSig
     *
     * @param  string $identifier identifier [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function generateUserSig (string $identifier) {
        return self::getClass()->generateUserSig([
            "identifier" => $identifier,
        ]);
    }

    /**
     * auto_send减1
     *
     * @support  string $serial_no 流水号 
     * @support  string $order_no 订单号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendReduce () {
        return self::getClass()->autoSendReduce();
    }

    /**
     * 判断订单是否是在线看片订单
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isOnlineOrderNum (string $order_num) {
        return self::getClass()->isOnlineOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Cloud\SerialNumber');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Cloud\SerialNumber');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}