<?php
namespace Mainto\Bridge\Invokes\PictureOnline\SmallProgram;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method readGuideByParams(array $params)
 * @method readStepByParams(array $params)
 * @method investigatedByParams(array $params)
 * @method saveSeeTypeByParams(array $params)
 * @method getSeeTypeByParams(array $params)
 * @method saveTakeTypeByParams(array $params)
 * @method getTakeTypeByParams(array $params)
 * @method getStoreInfoByParams(array $params)
 * @method getGuideVideoByParams(array $params)
 * @method seeGuideVideoByParams(array $params)
 * @method isFillSatisfactionByParams(array $params)
 */
class SerialNumber {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 手势引导已读
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readGuide () {
        return self::getClass()->readGuide();
    }

    /**
     * 步骤引导已读
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readStep () {
        return self::getClass()->readStep();
    }

    /**
     * 已调查
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function investigated () {
        return self::getClass()->investigated();
    }

    /**
     * 选择看片方式
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @support  string $see_type 看片方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSeeType () {
        return self::getClass()->saveSeeType();
    }

    /**
     * 获取看片方式
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSeeType () {
        return self::getClass()->getSeeType();
    }

    /**
     * 选择取片方式
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @support  string $take_type 取片方式 [ require true ]
     * @support  array $address 邮寄地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveTakeType () {
        return self::getClass()->saveTakeType();
    }

    /**
     * 获取取片方式
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTakeType () {
        return self::getClass()->getTakeType();
    }

    /**
     * 获取门店信息
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreInfo () {
        return self::getClass()->getStoreInfo();
    }

    /**
     * 获取引导视频
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGuideVideo () {
        return self::getClass()->getGuideVideo();
    }

    /**
     * 引导视频次数-1
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function seeGuideVideo () {
        return self::getClass()->seeGuideVideo();
    }

    /**
     * 满意度是否填写
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isFillSatisfaction (string $serial_no) {
        return self::getClass()->isFillSatisfaction([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'SmallProgram\SerialNumber');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'SmallProgram\SerialNumber');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}