<?php
namespace Mainto\Bridge\Invokes\PictureOnline\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updatePrintedByParams(array $params)
 * @method changePrintStatusByParams(array $params)
 * @method listsByParams(array $params)
 * @method detailByParams(array $params)
 * @method batchGetStatusByOrderNosByParams(array $params)
 * @method photoListByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method getAccountListByParams(array $params)
 * @method getShowPicOrderInfoByParams(array $params)
 * @method getSendInfoByAccountByParams(array $params)
 * @method updateStaffStartWaitAtByParams(array $params)
 * @method getStaffWaitInfoByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新订单打印状态
     *
     * @param  string $order_no 订单号 [ require true ]
     * @support  int $is_printed 打印状态 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePrinted (string $order_no) {
        return self::getClass()->updatePrinted([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 更新流水打印状态
     *
     * @param  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePrintStatus (string $serial_no) {
        return self::getClass()->changePrintStatus([
            "serial_no" => $serial_no,
        ]);
    }

    /**
     * 获取所有在线接单列表[订单]
     *
     * @support  string $status 订单状态 
     * @support  int $store 门店 
     * @support  string $customer_phone 顾客手机号 
     * @support  string $customer_name 顾客姓名 
     * @support  string $order_no 订单号 
     * @support  string $from 来源 
     * @support  int $retoucher 看片师id 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function lists (int $page_size = 10, int $page = 1) {
        return self::getClass()->lists([
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取在线看片订单详情[订单]
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (string $order_no) {
        return self::getClass()->detail([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 通过外部订单号批量获取状态
     *
     * @param  array $order_nos 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStatusByOrderNos (array $order_nos) {
        return self::getClass()->batchGetStatusByOrderNos([
            "order_nos" => $order_nos,
        ]);
    }

    /**
     * 获取订单图片列表
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function photoList (string $order_no) {
        return self::getClass()->photoList([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 修改取片方式
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @support  string $take_type 取片方式 [ require true ]
     * @support  int $province 邮寄省份 
     * @support  int $city 市 
     * @support  int $area 邮寄区域 
     * @support  string $detail 详细地址信息 
     * @support  string $name 收件人姓名 
     * @support  string $phone 收件人联系方式 
     * @support  string $post_num 寄件单号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeTakePhotoType () {
        return self::getClass()->changeTakePhotoType();
    }

    /**
     * 获取在线看片订单详情[订单管理]
     *
     * @support  int $store 门店 [ require true ]
     * @support  int $is_printed 打印 [Original type uint] 
     * @support  int $wait_posted 待邮寄 [Original type uint] 
     * @support  string $take_type 取片方式 
     * @throws  \Exception
     * @return  array
     */
    public static function getAccountList () {
        return self::getClass()->getAccountList();
    }

    /**
     * 获取修修兽详细信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShowPicOrderInfo (string $orderNum) {
        return self::getClass()->getShowPicOrderInfo([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取邮寄详细信息
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSendInfoByAccount (string $order_num) {
        return self::getClass()->getSendInfoByAccount([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 更新看片师开始等待时间点
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaffStartWaitAt (string $orderNum) {
        return self::getClass()->updateStaffStartWaitAt([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取伙伴等待状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWaitInfo (string $orderNum) {
        return self::getClass()->getStaffWaitInfo([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Cloud\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Cloud\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}