<?php
namespace Mainto\Bridge\Invokes\PictureOnline\SmallProgram;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method readGuideByParams(array $params)
 * @method readStepByParams(array $params)
 * @method investigatedByParams(array $params)
 */
class SerialNumber {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 手势引导已读
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readGuide () {
        return self::getClass()->readGuide();
    }

    /**
     * 步骤引导已读
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readStep () {
        return self::getClass()->readStep();
    }

    /**
     * 已调查
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function investigated () {
        return self::getClass()->investigated();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'SmallProgram\SerialNumber');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'SmallProgram\SerialNumber');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}