<?php
namespace Mainto\Bridge\Invokes\PictureOnline\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updatePrintedByParams(array $params)
 * @method listsByParams(array $params)
 * @method detailByParams(array $params)
 * @method photoListByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新订单打印状态
     *
     * @param  string $order_no 订单号 [ require true ]
     * @support  int $is_printed 打印状态 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePrinted (string $order_no) {
        return self::getClass()->updatePrinted([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 获取所有在线接单列表[订单]
     *
     * @support  string $status 订单状态 
     * @support  int $store 门店 
     * @support  string $customer_phone 顾客手机号 
     * @support  string $customer_name 顾客姓名 
     * @support  string $order_no 订单号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function lists (int $page_size = 10, int $page = 1) {
        return self::getClass()->lists([
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取在线看片订单详情[订单]
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (string $order_no) {
        return self::getClass()->detail([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 获取订单图片列表
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function photoList (string $order_no) {
        return self::getClass()->photoList([
            "order_no" => $order_no,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'Cloud\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'Cloud\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}