<?php
namespace Mainto\Bridge\Invokes\PictureOnline\SmallProgram;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveByParams(array $params)
 */
class SatisfactionDegree {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存满意度调查数据
     *
     * @support  string $serial_no 流水号 [ require true ]
     * @support  string $kps_response_speed 看片师响应速度 
     * @support  string $communication_experience 沟通体验 
     * @support  string $suggestion 建议 
     * @throws  \Exception
     * @return  mixed
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PictureOnline', 'SmallProgram\SatisfactionDegree');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PictureOnline', 'SmallProgram\SatisfactionDegree');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}