<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-04 11:13:46
 */
namespace Mainto\Bridge\Invokes\PbcSupplyDemand;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class DemandPoolController
 * @method deleteDemandPoolByParams(array $params) 删除需求池
 * @method addDemandPoolByParams(array $params) 添加需求池
 * @method getPageListToHandleByParams(array $params) 批量处理需求
 * @method deleteAllDemandPoolByParams(array $params) 清空需求池
 * @method getDemandPoolPageListByParams(array $params) 分页查询需求池列表
 * @method taskProcessLoopByParams(array $params) 开始处理需求
 * @method demandPoolHandleByParams(array $params) 开始处理需求
 */
class DemandPoolController {
    private static string $serviceName = "PbcSupplyDemand";

    private static string $className = "DemandPoolController";

    /**
     * 删除需求池
     * @return  bool
    */
    public static function deleteDemandPool (?\Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Supply\Demand\Facade\Vo\DeleteDemandPoolVO $deleteDemandPoolVO = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDemandPool($deleteDemandPoolVO);
    }

    /**
     * 添加需求池
     * @return  bool
    */
    public static function addDemandPool (?\Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Supply\Demand\Facade\Vo\AddDemandPoolVO $addDemandPoolVO = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addDemandPool($addDemandPoolVO);
    }

    /**
     * 批量处理需求
     * @return  bool
    */
    public static function getPageListToHandle (?\Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Supply\Demand\Facade\Req\GetPageListToHandleReq $getPageListToHandleReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPageListToHandle($getPageListToHandleReq);
    }

    /**
     * 清空需求池
     * @return  bool
    */
    public static function deleteAllDemandPool () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAllDemandPool();
    }

    /**
     * 分页查询需求池列表
     * @return  \Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Utils\Result\PageDto
    */
    public static function getDemandPoolPageList (?\Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Supply\Demand\Facade\Vo\DemandPoolPageListVO $demandPoolPageListVO = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDemandPoolPageList($demandPoolPageListVO),
            "\Mainto\Bridge\Structs\PbcSupplyDemand\Com\Mainto\Utils\Result\PageDto"
        );
    }

    /**
     * 开始处理需求
     * @return  void
    */
    public static function taskProcessLoop () {
         RpcClass::getClass(self::$serviceName, self::$className)->taskProcessLoop();
    }

    /**
     * 开始处理需求
     * @return  bool
    */
    public static function demandPoolHandle () {
        return RpcClass::getClass(self::$serviceName, self::$className)->demandPoolHandle();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}