<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-02-06 10:22:37
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Payment
 * @method changeWechatTestConfigByParams(array $params) 更改预发环境支付配置
 * @method addNewPaymentByParams(array $params) 预发新建支付单
 * @method paymentByParams(array $params) 申请支付
 * @method paymentV2ByParams(array $params) 聚合多源申请支付
 * @method checkOrderByPaymentStrByParams(array $params) 根据支付信息检查订单状态
 * @method checkOrderByPaymentIDByParams(array $params) 根据支付ID检查订单状态
 * @method closeOrderByOrderIdByParams(array $params) 根据订单号关闭订单
 * @method closeOrderByPaymentIDByParams(array $params) 根据支付ID关闭订单
 * @method refundByPaymentIDByParams(array $params) 根据支付ID退款
 * @method fixMultilateralByParams(array $params) 模拟支付回调，修复支付数据接口
 * @method retryRefundByParams(array $params) 根据老退款号创建新退款单进行二次退款重试
 * @method getRefundInfoByOrderByParams(array $params) 根据refundNum获取退款状态
 * @method getEncryptedPaymentIdByOrderIdByParams(array $params) 根据订单号获取加密流水ID
 * @method getEncryptedRefundNoByParams(array $params) 根据退款流水号获取加密流水号
 */
class Payment {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "Payment";

    /**
     * 更改预发环境支付配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function changeWechatTestConfig (string $subMchId = '123', float $needPayment = 1.01, bool $testInSandBox = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeWechatTestConfig(["subMchId" => $subMchId, "needPayment" => $needPayment, "testInSandBox" => $testInSandBox]);
    }

    /**
     * 预发新建支付单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addNewPayment (string $orderId, string $subMchId, float $needPayment, int $expiredTime = 3600, \Mainto\Bridge\Structs\PaymentGetway\Payment\AddNewPaymentParamsExtend $extend = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addNewPayment(["orderId" => $orderId, "subMchId" => $subMchId, "needPayment" => $needPayment, "expiredTime" => $expiredTime, "extend" => $extend]);
    }

    /**
     * 申请支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function payment (string $paymentStr, string $paymentType, string $paymentExtend = '{}') {
        return RpcClass::getClass(self::$serviceName, self::$className)->payment(["paymentStr" => $paymentStr, "paymentType" => $paymentType, "paymentExtend" => $paymentExtend]);
    }

    /**
     * 聚合多源申请支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function paymentV2 (string $paymentStr, string $paymentPoint, string $paymentMethod, string $paymentExtend = '{}') {
        return RpcClass::getClass(self::$serviceName, self::$className)->paymentV2(["paymentStr" => $paymentStr, "paymentPoint" => $paymentPoint, "paymentMethod" => $paymentMethod, "paymentExtend" => $paymentExtend]);
    }

    /**
     * 根据支付信息检查订单状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkOrderByPaymentStr (string $paymentStr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkOrderByPaymentStr(["paymentStr" => $paymentStr]);
    }

    /**
     * 根据支付ID检查订单状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkOrderByPaymentID (string $paymentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkOrderByPaymentID(["paymentId" => $paymentId]);
    }

    /**
     * 根据订单号关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeOrderByOrderId (string $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrderByOrderId(["orderId" => $orderId]);
    }

    /**
     * 根据支付ID关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeOrderByPaymentID (string $paymentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrderByPaymentID(["paymentId" => $paymentId]);
    }

    /**
     * 根据支付ID退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO
    */
    public static function refundByPaymentID (string $paymentId, float $refundAmount) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->refundByPaymentID(["paymentId" => $paymentId, "refundAmount" => $refundAmount]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO"
        );
    }

    /**
     * 模拟支付回调，修复支付数据接口
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function fixMultilateral (string $paymentId, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixMultilateral(["paymentId" => $paymentId, "id" => $id]);
    }

    /**
     * 根据老退款号创建新退款单进行二次退款重试
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function retryRefund (string $refundNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retryRefund(["refundNum" => $refundNum]);
    }

    /**
     * 根据refundNum获取退款状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO
    */
    public static function getRefundInfoByOrder (string $refundNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundInfoByOrder(["refundNum" => $refundNum]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO"
        );
    }

    /**
     * 根据订单号获取加密流水ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getEncryptedPaymentIdByOrderId (string $orderId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEncryptedPaymentIdByOrderId(["orderId" => $orderId, "type" => $type]);
    }

    /**
     * 根据退款流水号获取加密流水号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getEncryptedRefundNo (string $refundNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEncryptedRefundNo(["refundNo" => $refundNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}