<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-02-06 10:22:37
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Invoice
 * @method reviewElectronicInvoiceByParams(array $params) 审核电子发票
 * @method createElectronicInvoiceByParams(array $params) 开具电子普票
 * @method createSimpleElectronicInvoiceByParams(array $params) 开具电子普票(简易模式)
 * @method reverseInvoiceByParams(array $params) 发票冲红
 * @method createSimplePersonalPaperInvoiceByParams(array $params) 开具纸质普票(简易模式)
 * @method createSimpleCompanyPaperInvoiceByParams(array $params) 开具纸质专票(简易模式)
 * @method deliveryPaperInvoiceByParams(array $params) 设置纸质开票完成状态(进行邮寄)
 * @method getInvokeByIdByParams(array $params) 获取单个发票信息
 * @method getInvokesByIdsByParams(array $params) 获取多个发票信息
 * @method deleteInvokeByParams(array $params) 删除发票信息：只能删除状态为未开具的发票
 * @method forceInvalidByParams(array $params) 强制将发票标为作废（不会开出红票）
 * @method getAllowOrderInvokesByParams(array $params) 获取没开过发票的订单
 * @method getInvokesListByParams(array $params) 发票列表查询
 * @method checkInvoiceStatusRetryByParams(array $params) 检查开票是否成功
 * @method checkInvoiceStatusByParams(array $params) 检查开票是否成功
 * @method cronCheckSaasInvoiceStatusByParams(array $params) 每5分钟检查过去1天内的电子发票状态
 * @method cronCheckInvoiceStatusByParams(array $params) 每5分钟检查过去1天内的电子发票状态
 * @method queryCompanyListByParams(array $params) 关键字查询企业名称
 * @method queryNameAndTaxByCodeByParams(array $params) 开票代码查询名称及税号
 * @method callbackByParams(array $params) 发票结果回调（诺诺saas）
 * @method sendInvoiceStatusChangeMessageByParams(array $params) 重新发起发票完成消息
 */
class Invoice {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "Invoice";

    /**
     * 审核电子发票
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function reviewElectronicInvoice (int $invoice_id, bool $pass, array $complete_extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewElectronicInvoice(["invoice_id" => $invoice_id, "pass" => $pass, "complete_extend" => $complete_extend]);
    }

    /**
     * 开具电子普票
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createElectronicInvoice (string $buyername, bool $isNow, string $serviceType, string $orderno, string $invoicedate, string $clerk, string $salephone, string $saleaddress, string $saletaxnum, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createElectronicInvoice(["buyername" => $buyername, "isNow" => $isNow, "serviceType" => $serviceType, "orderno" => $orderno, "invoicedate" => $invoicedate, "clerk" => $clerk, "salephone" => $salephone, "saleaddress" => $saleaddress, "saletaxnum" => $saletaxnum, "detail" => $detail]);
    }

    /**
     * 开具电子普票(简易模式)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createSimpleElectronicInvoice (string $serviceType, bool $isNow, string $buyername, string $orderno, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSimpleElectronicInvoice(["serviceType" => $serviceType, "isNow" => $isNow, "buyername" => $buyername, "orderno" => $orderno, "detail" => $detail]);
    }

    /**
     * 发票冲红
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function reverseInvoice (int $invoiceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reverseInvoice(["invoiceId" => $invoiceId]);
    }

    /**
     * 开具纸质普票(简易模式)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createSimplePersonalPaperInvoice (string $buyername, string $serviceType, string $orderno, array $detail, string $delivery_area, string $delivery_address, string $delivery_people, string $delivery_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSimplePersonalPaperInvoice(["buyername" => $buyername, "serviceType" => $serviceType, "orderno" => $orderno, "detail" => $detail, "delivery_area" => $delivery_area, "delivery_address" => $delivery_address, "delivery_people" => $delivery_people, "delivery_phone" => $delivery_phone]);
    }

    /**
     * 开具纸质专票(简易模式)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createSimpleCompanyPaperInvoice (string $buyername, string $serviceType, string $taxnum, string $orderno, array $detail, string $telephone, string $address, string $account, string $delivery_area, string $delivery_address, string $delivery_people, string $delivery_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSimpleCompanyPaperInvoice(["buyername" => $buyername, "serviceType" => $serviceType, "taxnum" => $taxnum, "orderno" => $orderno, "detail" => $detail, "telephone" => $telephone, "address" => $address, "account" => $account, "delivery_area" => $delivery_area, "delivery_address" => $delivery_address, "delivery_people" => $delivery_people, "delivery_phone" => $delivery_phone]);
    }

    /**
     * 设置纸质开票完成状态(进行邮寄)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function deliveryPaperInvoice (int $invoice_id, string $delivery_id, string $delivery_company, string $serviceType = '', array $complete_extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deliveryPaperInvoice(["invoice_id" => $invoice_id, "delivery_id" => $delivery_id, "delivery_company" => $delivery_company, "serviceType" => $serviceType, "complete_extend" => $complete_extend]);
    }

    /**
     * 获取单个发票信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInvokeById (int $invoice_id, bool $include_reverse = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvokeById(["invoice_id" => $invoice_id, "include_reverse" => $include_reverse]);
    }

    /**
     * 获取多个发票信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInvokesByIds (array $invoice_ids, bool $include_reverse = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvokesByIds(["invoice_ids" => $invoice_ids, "include_reverse" => $include_reverse]);
    }

    /**
     * 删除发票信息：只能删除状态为未开具的发票
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function deleteInvoke (int $invoice_id, array $delete_extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteInvoke(["invoice_id" => $invoice_id, "delete_extend" => $delete_extend]);
    }

    /**
     * 强制将发票标为作废（不会开出红票）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function forceInvalid (int $invoice_id, array $invalid_extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forceInvalid(["invoice_id" => $invoice_id, "invalid_extend" => $invalid_extend]);
    }

    /**
     * 获取没开过发票的订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllowOrderInvokes (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllowOrderInvokes(["orderIds" => $orderIds]);
    }

    /**
     * 发票列表查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInvokesList (string $serviceType, bool $isElectronic, string $invokeType = '', string $startTime = '', string $endTime = '', string $status = '', array $orderIds = [], int $storeId = 0, string $title = '', int $page = 1, int $pageSize = 15, array $statusIn = [], string $orderId = '', array $invoiceIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInvokesList(["serviceType" => $serviceType, "isElectronic" => $isElectronic, "invokeType" => $invokeType, "startTime" => $startTime, "endTime" => $endTime, "status" => $status, "orderIds" => $orderIds, "storeId" => $storeId, "title" => $title, "page" => $page, "pageSize" => $pageSize, "statusIn" => $statusIn, "orderId" => $orderId, "invoiceIds" => $invoiceIds]);
    }

    /**
     * 检查开票是否成功
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function checkInvoiceStatusRetry (int $invoiceId, bool $isReverse = false) {
         RpcClass::getClass(self::$serviceName, self::$className)->checkInvoiceStatusRetry(["invoiceId" => $invoiceId, "isReverse" => $isReverse]);
    }

    /**
     * 检查开票是否成功
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function checkInvoiceStatus (int $invoiceId, bool $isReverse = false) {
         RpcClass::getClass(self::$serviceName, self::$className)->checkInvoiceStatus(["invoiceId" => $invoiceId, "isReverse" => $isReverse]);
    }

    /**
     * 每5分钟检查过去1天内的电子发票状态
     * @return  mixed
    */
    public static function cronCheckSaasInvoiceStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCheckSaasInvoiceStatus();
    }

    /**
     * 每5分钟检查过去1天内的电子发票状态
     * @return  mixed
    */
    public static function cronCheckInvoiceStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCheckInvoiceStatus();
    }

    /**
     * 关键字查询企业名称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function queryCompanyList (string $prefix) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryCompanyList(["prefix" => $prefix]);
    }

    /**
     * 开票代码查询名称及税号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function queryNameAndTaxByCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryNameAndTaxByCode(["code" => $code]);
    }

    /**
     * 发票结果回调（诺诺saas）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function callback (string $operater, string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callback(["operater" => $operater, "content" => $content]);
    }

    /**
     * 重新发起发票完成消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendInvoiceStatusChangeMessage (int $invoiceId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendInvoiceStatusChangeMessage(["invoiceId" => $invoiceId, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}