<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-18 18:07:36
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Alipay
 * @method checkOrderByIdByParams(array $params) 根据refundNum确认支付宝退款信息
 * @method showViewByParams(array $params) 支付宝跳转页面
 * @method returnWechatViewByParams(array $params) 支付成功页面
 * @method orderQueryByParams(array $params) 查询账单
 * @method orderQueryByAppIdByParams(array $params) 根据Appid查询账单
 * @method createRsaKeyByParams(array $params) 创建商户公私钥
 * @method createMerchantInfoByParams(array $params) 创建支付宝商户
 */
class Alipay {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "Alipay";

    /**
     * 根据refundNum确认支付宝退款信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkOrderById (string $paymentId, string $refundNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkOrderById(["paymentId" => $paymentId, "refundNum" => $refundNum]);
    }

    /**
     * 支付宝跳转页面
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function showView (string $url, string $reqUrl, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->showView(["url" => $url, "reqUrl" => $reqUrl, "code" => $code]);
    }

    /**
     * 支付成功页面
     * @return  string
    */
    public static function returnWechatView () {
        return RpcClass::getClass(self::$serviceName, self::$className)->returnWechatView();
    }

    /**
     * 查询账单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function orderQuery (string $subInstId, string $billDate, string $type = 'trade') {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderQuery(["subInstId" => $subInstId, "billDate" => $billDate, "type" => $type]);
    }

    /**
     * 根据Appid查询账单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function orderQueryByAppId (string $appId, string $billDate, string $type = 'trade') {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderQueryByAppId(["appId" => $appId, "billDate" => $billDate, "type" => $type]);
    }

    /**
     * 创建商户公私钥
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayRasKeyDTO
    */
    public static function createRsaKey () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createRsaKey(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayRasKeyDTO"
        );
    }

    /**
     * 创建支付宝商户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayMerchantDTO
    */
    public static function createMerchantInfo (string $appId, string $merchantCertPublic, string $merchantCertPrivate, string $alipayCertPublic) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createMerchantInfo(["appId" => $appId, "merchantCertPublic" => $merchantCertPublic, "merchantCertPrivate" => $merchantCertPrivate, "alipayCertPublic" => $alipayCertPublic]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayMerchantDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}