<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-24 11:47:42
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PaymentLink
 * @method createPaymentLinkByParams(array $params) 新建支付链接
 * @method getPageInfoByCodeByParams(array $params) 获取页面详情
 * @method doPaymentByParams(array $params) 进行支付
 * @method closePaymentLinkByIdByParams(array $params) 使用链接ID关闭支付链接
 * @method closePaymentLinkByOrderIdByParams(array $params) 使用订单ID关闭支付链接
 * @method closePaymentLinkByCodeByParams(array $params) 使用加密code关闭支付链接
 * @method firePaymentLinkNotifyByParams(array $params) 触发支付链接的通知
 * @method clearPaymentLinkByParams(array $params) 关闭过期订单
 */
class PaymentLink {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "PaymentLink";

    /**
     * 新建支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createPaymentLink (string $orderId, string $subMchId, float $needPayment, array $pageInfo, int $expiredTime = 3600, array $extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentLink(["orderId" => $orderId, "subMchId" => $subMchId, "needPayment" => $needPayment, "pageInfo" => $pageInfo, "expiredTime" => $expiredTime, "extend" => $extend]);
    }

    /**
     * 获取页面详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPageInfoByCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPageInfoByCode(["code" => $code]);
    }

    /**
     * 进行支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function doPayment (string $code, string $paymentType, string $paymentExtend = '{}') {
        return RpcClass::getClass(self::$serviceName, self::$className)->doPayment(["code" => $code, "paymentType" => $paymentType, "paymentExtend" => $paymentExtend]);
    }

    /**
     * 使用链接ID关闭支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function closePaymentLinkById (string $linkId) {
         RpcClass::getClass(self::$serviceName, self::$className)->closePaymentLinkById(["linkId" => $linkId]);
    }

    /**
     * 使用订单ID关闭支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function closePaymentLinkByOrderId (string $orderId) {
         RpcClass::getClass(self::$serviceName, self::$className)->closePaymentLinkByOrderId(["orderId" => $orderId]);
    }

    /**
     * 使用加密code关闭支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function closePaymentLinkByCode (string $code) {
         RpcClass::getClass(self::$serviceName, self::$className)->closePaymentLinkByCode(["code" => $code]);
    }

    /**
     * 触发支付链接的通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function firePaymentLinkNotify (string $data, string $sign) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firePaymentLinkNotify(["data" => $data, "sign" => $sign]);
    }

    /**
     * 关闭过期订单
     * @return  mixed
    */
    public static function clearPaymentLink () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearPaymentLink();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}