<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-22 18:23:34
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StoreMerchantBind
 */
class StoreMerchantBind {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "StoreMerchantBind";

    /**
     * 获取某家门店绑定的支付类型
     * @return  array
    */
    public static function getStoreBindPayType (int $storeId, bool $includeDefault = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreBindPayType(["storeId" => $storeId, "includeDefault" => $includeDefault]);
    }
    /**
     * 绑定门店支付类型
     * @return  array
    */
    public static function bindStorePayType (int $storeId, string $payType, string $merchantId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindStorePayType(["storeId" => $storeId, "payType" => $payType, "merchantId" => $merchantId]);
    }
    /**
     * 解绑门店支付类型
     * @return  bool
    */
    public static function deleteBindStorePayType (int $storeId, string $payType, string $merchantId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteBindStorePayType(["storeId" => $storeId, "payType" => $payType, "merchantId" => $merchantId]);
    }
    /**
     * 根据门店搜索列表
     * @return  mixed
    */
    public static function getStoreBindList (array $storeIds, array $payTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreBindList(["storeIds" => $storeIds, "payTypes" => $payTypes]);
    }
    /**
     * 根据商户ID获取绑定数据
     * @return  array
    */
    public static function getBindsByMerchantId (int $merchantId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBindsByMerchantId(["merchantId" => $merchantId]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantBindDTO[]"
        );
    }
    /**
     * 商户批量绑定门店
     * @return  bool
    */
    public static function batchStoreBind (int $merchantId, array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchStoreBind(["merchantId" => $merchantId, "storeIds" => $storeIds]);
    }
    /**
     * 获取抖音的所有商户门店信息
     * @return  array
    */
    public static function getDouyinMerchantStores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDouyinMerchantStores(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]"
        );
    }
    /**
     * 根据门店获取商户信息
     * @return  array
    */
    public static function getStoreMerchantByStoreIds (array $storeIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreMerchantByStoreIds(["storeIds" => $storeIds]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]"
        );
    }
    /**
     * 获取商户与所有门店的关系
     * @return  array
    */
    public static function getMerchantStores () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMerchantStores(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantStoresDTO[]"
        );
    }
    /**
     * 清除商户与门店的关系缓存
     * @return  bool
    */
    public static function clearMerchantStoresCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearMerchantStoresCache();
    }
    /**
     * 查询门店绑定商户列表
     * @return  array
    */
    public static function getStoreMerchantList (array $types = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreMerchantList(["types" => $types]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantBindDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}