<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-16 14:15:11
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class BatchPayment
 */
class BatchPayment {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "BatchPayment";

    /**
     * 新建合并支付单
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\BatchPaymentAddDTO
    */
    public static function addBatchPayment (array $orders, string $subMchId, float $needPayment, int $expiredTime, array $extend) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addBatchPayment(["orders" => $orders, "subMchId" => $subMchId, "needPayment" => $needPayment, "expiredTime" => $expiredTime, "extend" => $extend]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\BatchPaymentAddDTO"
        );
    }
    /**
     * 支付
     * @return  array
    */
    public static function batchPayment (string $code, string $paymentType, string $paymentExtend = '{}') {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchPayment(["code" => $code, "paymentType" => $paymentType, "paymentExtend" => $paymentExtend]);
    }
    /**
     * 根据订单号关闭订单，支持关闭 payment 或者 batchPayment 订单
     * @return  bool
    */
    public static function closeBatchPaymentByOrders (array $orderNums) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeBatchPaymentByOrders(["orderNums" => $orderNums]);
    }
    /**
     * 订单退款，支持子交易单和paymentId
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO
    */
    public static function paymentRefund (string $paymentId, float $refundAmount, \Mainto\Bridge\Structs\PaymentGetway\BatchPayment\PaymentRefundParamsExtend $extend) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paymentRefund(["paymentId" => $paymentId, "refundAmount" => $refundAmount, "extend" => $extend]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\RefundDTO"
        );
    }
    /**
     * 每10分钟查询一次是否支付成功
     * @return  bool
    */
    public static function syncPaymentState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncPaymentState();
    }
    /**
     * 根据子交易单获取子交易流水详情信息
     * @return  array
    */
    public static function getBatchPayments (array $subPaymentIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBatchPayments(["subPaymentIds" => $subPaymentIds]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\BatchPaymentDTO[]"
        );
    }
    /**
     * 支付回调
     * @return  bool
    */
    public static function fireBatchPaymentNotifyCallBack (string $data, string $sign) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fireBatchPaymentNotifyCallBack(["data" => $data, "sign" => $sign]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}