<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-18 19:00:23
 */
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Douyin
 */
class Douyin {
    private static string $serviceName = "PaymentGetway";

    private static string $className = "Douyin";

    /**
     * 进件商户号
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO
    */
    public static function addMerchant (string $name) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addMerchant(["name" => $name]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO"
        );
    }
    /**
     * 查看进件商户号详情
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO
    */
    public static function getMerchant (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMerchant(["id" => $id]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO"
        );
    }
    /**
     * 获取进件商户号列表，分页
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\DouyinMerchantPageDTO
    */
    public static function merchantsByPage (int $page = 1, int $pageSize = 15, string $name, string $merchantId, int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->merchantsByPage(["page" => $page, "pageSize" => $pageSize, "name" => $name, "merchantId" => $merchantId, "storeId" => $storeId]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\DouyinMerchantPageDTO"
        );
    }
    /**
     * 请求分账
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\SettleDTO
    */
    public static function settleByPaymentId (string $paymentId, \Mainto\Bridge\Structs\PaymentGetway\Douyin\SettleByPaymentIdParamsExtend $extend = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->settleByPaymentId(["paymentId" => $paymentId, "extend" => $extend]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\SettleDTO"
        );
    }
    /**
     * 请求分账查询
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\SettleDTO
    */
    public static function getSettleInfo (string $settleNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSettleInfo(["settleNo" => $settleNo]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\SettleDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}