<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkRefundCronByParams(array $params)
 * @method checkPaymentCronByParams(array $params)
 * @method checkSettleCronByParams(array $params)
 * @method getSettleBillsByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每10分钟查询一次是否退款成功
     *
     * @support  string $refundNum 退款流水号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkRefundCron () {
        return self::getClass()->checkRefundCron([
        ]);
    }

    /**
     * 每10分钟查询一次是否支付成功
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkPaymentCron () {
        return self::getClass()->checkPaymentCron();
    }

    /**
     * 每10分钟查询一次是否分账成功
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkSettleCron () {
        return self::getClass()->checkSettleCron();
    }

    /**
     * 获取抖音分账账单
     *
     * @support  string $date 拉取日期 [ require false ]
     * @throws  \Exception
     * @return  void
     */
    public static function getSettleBills () {
        return self::getClass()->getSettleBills([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}