<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkOrderByIdByParams(array $params)
 * @method showViewByParams(array $params)
 * @method returnWechatViewByParams(array $params)
 * @method orderQueryByParams(array $params)
 * @method orderQueryByAppIdByParams(array $params)
 * @method createRsaKeyByParams(array $params)
 * @method createMerchantInfoByParams(array $params)
 */
class Alipay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据refundNum确认支付宝退款信息
     *
     * @param  string $paymentId 订单号 [ require true ]
     * @param  string $refundNum 退款号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderById (string $paymentId, string $refundNum) {
        return self::getClass()->checkOrderById([
            "paymentId" => $paymentId,
            "refundNum" => $refundNum,
        ]);
    }

    /**
     * 支付宝跳转页面
     *
     * @param  string $url 回调地址 [ require true ]
     * @param  string $reqUrl 请求地址 [ require true ]
     * @param  string $code 支付码 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function showView (string $url, string $reqUrl, string $code) {
        return self::getClass()->showView([
            "url" => $url,
            "reqUrl" => $reqUrl,
            "code" => $code,
        ]);
    }

    /**
     * 支付成功页面
     *
     * @throws  \Exception
     * @return  string
     */
    public static function returnWechatView () {
        return self::getClass()->returnWechatView();
    }

    /**
     * 查询账单
     *
     * @param  string $subInstId 子商户id [ require true ]
     * @param  string $billDate 对账单日期 [ require true ]
     * @param  string $type 对账单类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderQuery (string $subInstId, string $billDate, string $type = 'trade') {
        return self::getClass()->orderQuery([
            "subInstId" => $subInstId,
            "billDate" => $billDate,
            "type" => $type,
        ]);
    }

    /**
     * 根据Appid查询账单
     *
     * @param  string $appId app id [ require true ]
     * @param  string $billDate 对账单日期 [ require true ]
     * @param  string $type 对账单类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderQueryByAppId (string $appId, string $billDate, string $type = 'trade') {
        return self::getClass()->orderQueryByAppId([
            "appId" => $appId,
            "billDate" => $billDate,
            "type" => $type,
        ]);
    }

    /**
     * 创建商户公私钥
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayRasKeyDTO
     */
    public static function createRsaKey () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createRsaKey(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayRasKeyDTO"
        );
    }

    /**
     * 创建支付宝商户
     *
     * @param  string $appId 支付宝appid [ require true ]
     * @param  string $merchantCertPublic 商户公钥 [ require true ]
     * @param  string $merchantCertPrivate 商户私钥 [ require true ]
     * @param  string $alipayCertPublic 支付宝公钥 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayMerchantDTO
     */
    public static function createMerchantInfo (string $appId, string $merchantCertPublic, string $merchantCertPrivate, string $alipayCertPublic) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMerchantInfo([
                            "appId" => $appId,
                            "merchantCertPublic" => $merchantCertPublic,
                            "merchantCertPrivate" => $merchantCertPrivate,
                            "alipayCertPublic" => $alipayCertPublic,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\AlipayMerchantDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Alipay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Alipay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}