<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paymentAppAlipayNotifyByParams(array $params)
 * @method paymentICBCWechatNotifyByParams(array $params)
 * @method paymentPaymaxWechatNotifyByParams(array $params)
 * @method paymentPaymaxAlipayNotifyByParams(array $params)
 * @method paymentOffPaymaxAlipayNotifyByParams(array $params)
 * @method paymentOffPaymaxWechatNotifyByParams(array $params)
 * @method paymentOffPaymaxCardNotifyByParams(array $params)
 * @method paymentPaymaxWechatMiniAppNotifyByParams(array $params)
 * @method paymentWechatNotifyByParams(array $params)
 * @method paymentDouyinNotifyByParams(array $params)
 * @method refundDouyinNotifyByParams(array $params)
 * @method paymentAlipayNotifyByParams(array $params)
 * @method PaymaxAlipayMiniAppNotifyByParams(array $params)
 * @method settleDouyinNotifyByParams(array $params)
 */
class PaymentCallback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付宝APP支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentAppAlipayNotify () {
        return self::getClass()->paymentAppAlipayNotify();
    }

    /**
     * 工行微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentICBCWechatNotify () {
        return self::getClass()->paymentICBCWechatNotify();
    }

    /**
     * 拉卡拉微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxWechatNotify () {
        return self::getClass()->paymentPaymaxWechatNotify();
    }

    /**
     * 拉卡拉支付宝支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxAlipayNotify () {
        return self::getClass()->paymentPaymaxAlipayNotify();
    }

    /**
     * 拉卡拉线下支付宝回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxAlipayNotify () {
        return self::getClass()->paymentOffPaymaxAlipayNotify();
    }

    /**
     * 拉卡拉线下微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxWechatNotify () {
        return self::getClass()->paymentOffPaymaxWechatNotify();
    }

    /**
     * 拉卡拉线下银行卡支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxCardNotify () {
        return self::getClass()->paymentOffPaymaxCardNotify();
    }

    /**
     * 拉卡拉小程序支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxWechatMiniAppNotify () {
        return self::getClass()->paymentPaymaxWechatMiniAppNotify();
    }

    /**
     * 微信支付回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function paymentWechatNotify () {
        return self::getClass()->paymentWechatNotify();
    }

    /**
     * 抖音支付回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function paymentDouyinNotify () {
        return self::getClass()->paymentDouyinNotify();
    }

    /**
     * 抖音退款回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function refundDouyinNotify () {
        return self::getClass()->refundDouyinNotify();
    }

    /**
     * 支付宝支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentAlipayNotify () {
        return self::getClass()->paymentAlipayNotify();
    }

    /**
     * 支付宝小程序支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function PaymaxAlipayMiniAppNotify () {
        return self::getClass()->PaymaxAlipayMiniAppNotify();
    }

    /**
     * 抖音分账回调接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function settleDouyinNotify () {
        return self::getClass()->settleDouyinNotify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'PaymentCallback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'PaymentCallback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}