<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeWechatTestConfigByParams(array $params)
 * @method addNewPaymentByParams(array $params)
 * @method paymentByParams(array $params)
 * @method checkOrderByPaymentStrByParams(array $params)
 * @method checkOrderByPaymentIDByParams(array $params)
 * @method paymentICBCWechatNotifyByParams(array $params)
 * @method paymentPaymaxWechatNotifyByParams(array $params)
 * @method paymentPaymaxAlipayNotifyByParams(array $params)
 * @method paymentOffPaymaxAlipayNotifyByParams(array $params)
 * @method paymentOffPaymaxWechatNotifyByParams(array $params)
 * @method paymentOffPaymaxCardNotifyByParams(array $params)
 * @method paymentPaymaxWechatMiniAppNotifyByParams(array $params)
 * @method paymentWechatNotifyByParams(array $params)
 * @method paymentAlipayNotifyByParams(array $params)
 * @method PaymaxAlipayMiniAppNotifyByParams(array $params)
 * @method paymentAppAlipayNotifyByParams(array $params)
 * @method closeOrderByOrderIdByParams(array $params)
 * @method closeOrderByPaymentIDByParams(array $params)
 * @method refundByPaymentIDByParams(array $params)
 * @method showRefundByPaymentIdByParams(array $params)
 * @method checkPaymentCronByParams(array $params)
 * @method fixMultilateralByParams(array $params)
 */
class Payment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更改预发环境支付配置
     *
     * @support  string $subMchId 子商户ID [ require false ]
     * @support  float $needPayment 需要支付的金额 [ require false ]
     * @support  bool $testInSandBox 是否在沙盒中测试 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeWechatTestConfig () {
        return self::getClass()->changeWechatTestConfig([
        ]);
    }

    /**
     * 预发新建支付单
     *
     * @param  string $orderId 原始订单ID [ require true ]
     * @param  string $subMchId 子商户ID [ require true ]
     * @param  float $needPayment 需要支付的金额 [ require true ]
     * @param  int $expiredTime 过期时间 [ require false ]
     * @param  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewPayment (string $orderId, string $subMchId, float $needPayment, int $expiredTime = 3600, array $extend = []) {
        return self::getClass()->addNewPayment([
            "orderId" => $orderId,
            "subMchId" => $subMchId,
            "needPayment" => $needPayment,
            "expiredTime" => $expiredTime,
            "extend" => $extend,
        ]);
    }

    /**
     * 申请支付
     *
     * @param  string $paymentStr 加密后的支付信息 [ require true ]
     * @param  string $paymentType 支付类型(eg. Alipay: 支付宝支付, Wechat: 微信支付 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function payment (string $paymentStr, string $paymentType, string $paymentExtend = '{}') {
        return self::getClass()->payment([
            "paymentStr" => $paymentStr,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
        ]);
    }

    /**
     * 根据支付信息检查订单状态
     *
     * @param  string $paymentStr 加密后的支付信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderByPaymentStr (string $paymentStr) {
        return self::getClass()->checkOrderByPaymentStr([
            "paymentStr" => $paymentStr,
        ]);
    }

    /**
     * 根据支付ID检查订单状态
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOrderByPaymentID (string $paymentId) {
        return self::getClass()->checkOrderByPaymentID([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 工行微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentICBCWechatNotify () {
        return self::getClass()->paymentICBCWechatNotify();
    }

    /**
     * 拉卡拉微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxWechatNotify () {
        return self::getClass()->paymentPaymaxWechatNotify();
    }

    /**
     * 拉卡拉支付宝支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxAlipayNotify () {
        return self::getClass()->paymentPaymaxAlipayNotify();
    }

    /**
     * 拉卡拉线下支付宝回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxAlipayNotify () {
        return self::getClass()->paymentOffPaymaxAlipayNotify();
    }

    /**
     * 拉卡拉线下微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxWechatNotify () {
        return self::getClass()->paymentOffPaymaxWechatNotify();
    }

    /**
     * 拉卡拉线下银行卡支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentOffPaymaxCardNotify () {
        return self::getClass()->paymentOffPaymaxCardNotify();
    }

    /**
     * 拉卡拉小程序支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentPaymaxWechatMiniAppNotify () {
        return self::getClass()->paymentPaymaxWechatMiniAppNotify();
    }

    /**
     * 微信支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentWechatNotify () {
        return self::getClass()->paymentWechatNotify();
    }

    /**
     * 支付宝支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentAlipayNotify () {
        return self::getClass()->paymentAlipayNotify();
    }

    /**
     * 支付宝小程序支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function PaymaxAlipayMiniAppNotify () {
        return self::getClass()->PaymaxAlipayMiniAppNotify();
    }

    /**
     * 支付宝APP支付回调接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentAppAlipayNotify () {
        return self::getClass()->paymentAppAlipayNotify();
    }

    /**
     * 根据订单号关闭订单
     *
     * @param  string $orderId 商户原始订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderByOrderId (string $orderId) {
        return self::getClass()->closeOrderByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据支付ID关闭订单
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderByPaymentID (string $paymentId) {
        return self::getClass()->closeOrderByPaymentID([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 根据支付ID退款
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @param  float $refundAmount 退款金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundByPaymentID (string $paymentId, float $refundAmount) {
        return self::getClass()->refundByPaymentID([
            "paymentId" => $paymentId,
            "refundAmount" => $refundAmount,
        ]);
    }

    /**
     * 查询退款日志
     *
     * @param  string $paymentId 支付ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showRefundByPaymentId (string $paymentId) {
        return self::getClass()->showRefundByPaymentId([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * 每10分钟查询一次是否支付成功
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkPaymentCron () {
        return self::getClass()->checkPaymentCron();
    }

    /**
     * 根据支付ID退款，修复接口
     *
     * @param  string $paymentId 账单ID [ require true ]
     * @param  int $id 支付ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function fixMultilateral (string $paymentId, int $id) {
        return self::getClass()->fixMultilateral([
            "paymentId" => $paymentId,
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Payment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Payment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}