<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkUSCCByParams(array $params)
 * @method checkPRCIdCardByParams(array $params)
 */
class Util {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Unified Social Credit Code
     * 少数个体工商户可能为身份证号码
     *
     * @param  string $code USCC Code [ require true ]
     * @param  bool $strict 严格模式, 该模式下身份证号码将会返回失败 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUSCC (string $code, bool $strict = false) {
        return self::getClass()->checkUSCC([
            "code" => $code,
            "strict" => $strict,
        ]);
    }

    /**
     * People&#039;s Republic of China ID card
     *
     * @param  string $code PRCIdCard Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkPRCIdCard (string $code) {
        return self::getClass()->checkPRCIdCard([
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Util');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Util');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}