<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addMerchantByParams(array $params)
 * @method getMerchantByParams(array $params)
 * @method merchantsByPageByParams(array $params)
 * @method addSettleByParams(array $params)
 * @method getSettleInfoByParams(array $params)
 */
class DouyinMerchant {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 进件商户号
     *
     * @param  string $name 商户名称 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO
     */
    public static function addMerchant (string $name) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addMerchant([
                            "name" => $name,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO"
        );
    }

    /**
     * 查看进件商户号详情
     *
     * @param  int $id 商户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO
     */
    public static function getMerchant (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMerchant([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantResponseDTO"
        );
    }

    /**
     * 获取进件商户号列表，分页
     *
     * @support  string $name 商户名称 [ require false ]
     * @support  string $merchantId 商户ID [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\DouyinMerchantPageDTO
     */
    public static function merchantsByPage (int $page = 1, int $pageSize = 15) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->merchantsByPage([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\DouyinMerchantPageDTO"
        );
    }

    /**
     * 请求分账
     *
     * @param  string $orderId 聚合后订单ID [ require true ]
     * @support  mixed $extend 退款详情信息 [ require false ]
     * @throws  \Exception
     * @return  string[]
     */
    public static function addSettle (string $orderId) {
        return self::getClass()->addSettle([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 请求分账查询
     *
     * @param  string $orderId 聚合后订单ID [ require true ]
     * @throws  \Exception
     * @return  array[]
     */
    public static function getSettleInfo (string $orderId) {
        return self::getClass()->getSettleInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'DouyinMerchant');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'DouyinMerchant');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}