<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showCurrentAmountByParams(array $params)
 * @method amountWithdrawByParams(array $params)
 * @method orderQueryByParams(array $params)
 * @method autoAmountWithdrawByParams(array $params)
 */
class ICBC {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 显示账户余额
     *
     * @param  string $subInstId 子商户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showCurrentAmount (string $subInstId) {
        return self::getClass()->showCurrentAmount([
            "subInstId" => $subInstId,
        ]);
    }

    /**
     * 进行账户提现
     *
     * @param  string $subInstId 子商户ID [ require true ]
     * @param  float $amount 提现金额 [ require true ]
     * @param  string $comment 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function amountWithdraw (string $subInstId, float $amount, string $comment) {
        return self::getClass()->amountWithdraw([
            "subInstId" => $subInstId,
            "amount" => $amount,
            "comment" => $comment,
        ]);
    }

    /**
     * 查询账单
     *
     * @param  string $subInstId 子商户ID [ require true ]
     * @param  string $billDate 对账单日期 [ require true ]
     * @param  int $page 页码标志 [ require true ]
     * @param  string $orderNo 订单编号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderQuery (string $subInstId, string $billDate, int $page, string $orderNo = '') {
        return self::getClass()->orderQuery([
            "subInstId" => $subInstId,
            "billDate" => $billDate,
            "page" => $page,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 自动提现
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoAmountWithdraw () {
        return self::getClass()->autoAmountWithdraw();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'ICBC');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'ICBC');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}