<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreBindPayTypeByParams(array $params)
 * @method bindStorePayTypeByParams(array $params)
 * @method deleteBindStorePayTypeByParams(array $params)
 * @method getStoreBindListByParams(array $params)
 * @method getBindsByMerchantIdByParams(array $params)
 * @method batchStoreBindByParams(array $params)
 * @method getDouyinMerchantStoresByParams(array $params)
 * @method getStoreMerchantByStoreIdsByParams(array $params)
 * @method getMerchantStoresByParams(array $params)
 * @method clearMerchantStoresCacheByParams(array $params)
 */
class StoreMerchantBind {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店绑定的支付类型
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  bool $includeDefault 包含默认的支付类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreBindPayType (int $storeId, bool $includeDefault = true) {
        return self::getClass()->getStoreBindPayType([
            "storeId" => $storeId,
            "includeDefault" => $includeDefault,
        ]);
    }

    /**
     * 绑定门店支付类型
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $merchantId 商户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindStorePayType (int $storeId, string $payType, string $merchantId) {
        return self::getClass()->bindStorePayType([
            "storeId" => $storeId,
            "payType" => $payType,
            "merchantId" => $merchantId,
        ]);
    }

    /**
     * 解绑门店支付类型
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @support  string $merchantId 商户ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteBindStorePayType (int $storeId, string $payType) {
        return self::getClass()->deleteBindStorePayType([
            "storeId" => $storeId,
            "payType" => $payType,
        ]);
    }

    /**
     * 根据门店搜索列表
     *
     * @support  array $storeIds 门店ID数组 [ require true ]
     * @support  array $payTypes 支付类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreBindList () {
        return self::getClass()->getStoreBindList([
        ]);
    }

    /**
     * 根据商户ID获取绑定数据
     *
     * @param  int $merchantId 商户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantBindDTO[]
     */
    public static function getBindsByMerchantId (int $merchantId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBindsByMerchantId([
                            "merchantId" => $merchantId,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantBindDTO[]"
        );
    }

    /**
     * 商户批量绑定门店
     *
     * @param  int $merchantId 商户ID [ require true ]
     * @param  array $storeIds 门店ID数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchStoreBind (int $merchantId, array $storeIds = []) {
        return self::getClass()->batchStoreBind([
            "merchantId" => $merchantId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取抖音的所有商户门店信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]
     */
    public static function getDouyinMerchantStores () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDouyinMerchantStores(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]"
        );
    }

    /**
     * 根据门店获取商户信息
     *
     * @param  array $storeIds 门店ID数组 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]
     */
    public static function getStoreMerchantByStoreIds (array $storeIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreMerchantByStoreIds([
                            "storeIds" => $storeIds,
                        ]),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\StoreMerchantMapDTO[]"
        );
    }

    /**
     * 获取商户与所有门店的关系
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantStoresDTO[]
     */
    public static function getMerchantStores () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMerchantStores(),
            "\Mainto\Bridge\Structs\PaymentGetway\Controllers\DTO\MerchantStoresDTO[]"
        );
    }

    /**
     * 清除商户与门店的关系缓存
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function clearMerchantStoresCache () {
        return self::getClass()->clearMerchantStoresCache();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'StoreMerchantBind');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'StoreMerchantBind');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}