<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addBatchPaymentByParams(array $params)
 * @method batchPaymentByParams(array $params)
 * @method closeBatchPaymentByOrdersByParams(array $params)
 * @method paymentRefundByParams(array $params)
 * @method fireBatchPaymentNotifyCallBackByParams(array $params)
 * @method syncPaymentStateByParams(array $params)
 * @method testCallbackByParams(array $params)
 */
class BatchPayment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建合并支付单
     *
     * @param  mixed $orders 订单信息 [ require true ]
     * @param  string $subMchId 子商户ID [ require true ]
     * @param  float $needPayment 需要支付的金额(单位为元) [ require true ]
     * @param  int $expiredTime 过期时间 [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addBatchPayment ($orders, string $subMchId, float $needPayment, int $expiredTime = 3600, array $extend = []) {
        return self::getClass()->addBatchPayment([
            "orders" => $orders,
            "subMchId" => $subMchId,
            "needPayment" => $needPayment,
            "expiredTime" => $expiredTime,
            "extend" => $extend,
        ]);
    }

    /**
     * 进行支付
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型(eg. Alipay: 支付宝支付, Wechat: 微信支付) [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchPayment (string $code, string $paymentType, string $paymentExtend = '{}') {
        return self::getClass()->batchPayment([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
        ]);
    }

    /**
     * 根据订单号关闭订单，支持关闭 payment 或者 batchPayment 订单
     *
     * @param  array $orderNums 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeBatchPaymentByOrders (array $orderNums) {
        return self::getClass()->closeBatchPaymentByOrders([
            "orderNums" => $orderNums,
        ]);
    }

    /**
     * 订单退款，支持子交易单和payemntId
     *
     * @param  string $paymentId 支付信息 [ require true ]
     * @param  float $refundAmount 退款金额(以元为单位) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentRefund (string $paymentId, float $refundAmount) {
        return self::getClass()->paymentRefund([
            "paymentId" => $paymentId,
            "refundAmount" => $refundAmount,
        ]);
    }

    /**
     * 支付回调
     *
     * @param  string $data json的支付信息 [ require true ]
     * @param  string $sign 支付签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function fireBatchPaymentNotifyCallBack (string $data, string $sign) {
        return self::getClass()->fireBatchPaymentNotifyCallBack([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * 每10分钟查询一次是否支付成功
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncPaymentState () {
        return self::getClass()->syncPaymentState();
    }

    /**
     * 用户 release 自测回调
     *
     * @param  string $paymentId 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function testCallback (string $paymentId) {
        return self::getClass()->testCallback([
            "paymentId" => $paymentId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'BatchPayment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'BatchPayment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}