<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addBatchPaymentByParams(array $params)
 * @method batchPaymentByParams(array $params)
 * @method closeBatchPaymentByCodeByParams(array $params)
 * @method closeBatchPaymentByOrdersByParams(array $params)
 * @method paymentRefundByParams(array $params)
 * @method fireBatchPaymentNotifyCallBackByParams(array $params)
 */
class BatchPayment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建合并支付单
     *
     * @param  mixed $orders 订单信息 [ require true ]
     * @param  string $subMchId 子商户ID [ require true ]
     * @param  float $needPayment 需要支付的金额(单位为元) [ require true ]
     * @param  int $expiredTime 过期时间 [ require true ]
     * @param  string $hashCode 唯一标识 [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addBatchPayment ($orders, string $subMchId, float $needPayment, string $hashCode, int $expiredTime = 3600, array $extend = []) {
        return self::getClass()->addBatchPayment([
            "orders" => $orders,
            "subMchId" => $subMchId,
            "needPayment" => $needPayment,
            "hashCode" => $hashCode,
            "expiredTime" => $expiredTime,
            "extend" => $extend,
        ]);
    }

    /**
     * 进行支付
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型(eg. Alipay: 支付宝支付, Wechat: 微信支付 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchPayment (string $code, string $paymentType, string $paymentExtend = '{}') {
        return self::getClass()->batchPayment([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
        ]);
    }

    /**
     * 根据 code 关闭订单
     *
     * @param  string $code 支付信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeBatchPaymentByCode (string $code) {
        return self::getClass()->closeBatchPaymentByCode([
            "code" => $code,
        ]);
    }

    /**
     * 根据订单号关闭订单
     *
     * @param  array $orderIds 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeBatchPaymentByOrders (array $orderIds) {
        return self::getClass()->closeBatchPaymentByOrders([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 订单退款，支持子交易单和payemnt
     *
     * @param  string $id 支付信息 [ require true ]
     * @param  float $refundAmount 退款金额(以元为单位) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentRefund (string $id, float $refundAmount) {
        return self::getClass()->paymentRefund([
            "id" => $id,
            "refundAmount" => $refundAmount,
        ]);
    }

    /**
     * 支付回调
     *
     * @param  string $data json的支付信息 [ require true ]
     * @param  string $sign 支付签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function fireBatchPaymentNotifyCallBack (string $data, string $sign) {
        return self::getClass()->fireBatchPaymentNotifyCallBack([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'BatchPayment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'BatchPayment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}