<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paymaxMerchantCallbackByParams(array $params)
 * @method newMerchantByParams(array $params)
 * @method changeMerchantByParams(array $params)
 * @method listMerchantByParams(array $params)
 * @method initPosByParams(array $params)
 * @method cachePosInfoByParams(array $params)
 * @method bindPosByParams(array $params)
 * @method getPosListByParams(array $params)
 * @method getStsTokenByParams(array $params)
 */
class PayMax {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拉卡拉审核回调
     *
     * @param  string $contractId 进件ID [ require true ]
     * @param  string $shopNo 拉卡拉商铺ID [ require true ]
     * @param  string $termNos 拉卡拉终端号 [ require true ]
     * @param  string $contractStatus 审核状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymaxMerchantCallback (string $contractId, string $shopNo, string $termNos, string $contractStatus) {
        return self::getClass()->paymaxMerchantCallback([
            "contractId" => $contractId,
            "shopNo" => $shopNo,
            "termNos" => $termNos,
            "contractStatus" => $contractStatus,
        ]);
    }

    /**
     * 拉卡拉进件
     *
     * @param  string $wechatAppId 微信公众号APPID [ require true ]
     * @param  array $info 进件信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newMerchant (string $wechatAppId, array $info) {
        return self::getClass()->newMerchant([
            "wechatAppId" => $wechatAppId,
            "info" => $info,
        ]);
    }

    /**
     * 拉卡拉修改进件信息
     *
     * @param  string $wechatAppId 微信公众号APPID [ require true ]
     * @param  int $merchantId 商户ID [ require true ]
     * @param  array $info 进件信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMerchant (int $merchantId, string $wechatAppId, array $info) {
        return self::getClass()->changeMerchant([
            "merchantId" => $merchantId,
            "wechatAppId" => $wechatAppId,
            "info" => $info,
        ]);
    }

    /**
     * 拉卡拉进件列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $num 每页数目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMerchant (int $page = 1, int $num = 10) {
        return self::getClass()->listMerchant([
            "page" => $page,
            "num" => $num,
        ]);
    }

    /**
     * POS机初始化接口
     *
     * @support  string $imei imei [ require true ]
     * @support  array $ipList ipList require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function initPos () {
        return self::getClass()->initPos();
    }

    /**
     * POS机信息暂存接口
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cachePosInfo (int $storeId) {
        return self::getClass()->cachePosInfo([
            "storeId" => $storeId,
        ]);
    }

    /**
     * POS机绑定接口
     *
     * @support  string $imei imei [ require true ]
     * @support  string $imsi imsi require false
     * @support  string $ksn ksn require false
     * @support  string $merid merid [ require true ]
     * @support  string $merTermId merTermId [ require true ]
     * @support  string $cacheId cacheId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindPos () {
        return self::getClass()->bindPos();
    }

    /**
     * 门店pos列表
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPosList (int $storeId) {
        return self::getClass()->getPosList([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取StsToken
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStsToken () {
        return self::getClass()->getStsToken();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'PayMax');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'PayMax');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}