<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPaymentLinkByParams(array $params)
 * @method getPageInfoByCodeByParams(array $params)
 * @method doPaymentByParams(array $params)
 * @method closePaymentLinkByIdByParams(array $params)
 * @method closePaymentLinkByOrderIdByParams(array $params)
 * @method closePaymentLinkByCodeByParams(array $params)
 * @method firePaymentLinkNotifyByParams(array $params)
 * @method clearPaymentLinkByParams(array $params)
 */
class PaymentLink {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建支付链接
     *
     * @param  string $orderId 原始订单ID [ require true ]
     * @param  string $subMchId 子商户ID [ require true ]
     * @param  float $needPayment 需要支付的金额(单位为元) [ require true ]
     * @param  int $expiredTime 过期时间 [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @param  array $pageInfo 页面信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createPaymentLink (string $orderId, string $subMchId, float $needPayment, array $pageInfo, int $expiredTime = 3600, array $extend = []) {
        return self::getClass()->createPaymentLink([
            "orderId" => $orderId,
            "subMchId" => $subMchId,
            "needPayment" => $needPayment,
            "pageInfo" => $pageInfo,
            "expiredTime" => $expiredTime,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取页面详情
     *
     * @param  string $code 支付信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPageInfoByCode (string $code) {
        return self::getClass()->getPageInfoByCode([
            "code" => $code,
        ]);
    }

    /**
     * 进行支付
     *
     * @param  string $code 支付信息 [ require true ]
     * @param  string $paymentType 支付类型(eg. Alipay: 支付宝支付, Wechat: 微信支付 [ require true ]
     * @param  string $paymentExtend 额外支付信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function doPayment (string $code, string $paymentType, string $paymentExtend = '{}') {
        return self::getClass()->doPayment([
            "code" => $code,
            "paymentType" => $paymentType,
            "paymentExtend" => $paymentExtend,
        ]);
    }

    /**
     * 使用链接ID关闭支付链接
     *
     * @param  string $linkId 支付信息 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function closePaymentLinkById (string $linkId) {
        return self::getClass()->closePaymentLinkById([
            "linkId" => $linkId,
        ]);
    }

    /**
     * 使用链接ID关闭支付链接
     *
     * @param  string $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function closePaymentLinkByOrderId (string $orderId) {
        return self::getClass()->closePaymentLinkByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 使用链接ID关闭支付链接
     *
     * @param  string $code 支付加密信息 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function closePaymentLinkByCode (string $code) {
        return self::getClass()->closePaymentLinkByCode([
            "code" => $code,
        ]);
    }

    /**
     * 触发支付链接的通知
     *
     * @param  string $data json的支付信息 [ require true ]
     * @param  string $sign 支付签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function firePaymentLinkNotify (string $data, string $sign) {
        return self::getClass()->firePaymentLinkNotify([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * 关闭过期订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearPaymentLink () {
        return self::getClass()->clearPaymentLink();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'PaymentLink');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'PaymentLink');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}