<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reviewElectronicInvoiceByParams(array $params)
 * @method createElectronicInvoiceByParams(array $params)
 * @method createSimpleElectronicInvoiceByParams(array $params)
 * @method reverseInvoiceByParams(array $params)
 * @method createSimplePersonalPaperInvoiceByParams(array $params)
 * @method createSimpleCompanyPaperInvoiceByParams(array $params)
 * @method deliveryPaperInvoiceByParams(array $params)
 * @method getInvokeByIdByParams(array $params)
 * @method getInvokesByIdsByParams(array $params)
 * @method deleteInvokeByParams(array $params)
 * @method forceInvalidByParams(array $params)
 * @method getAllowOrderInvokesByParams(array $params)
 * @method getInvokesListByParams(array $params)
 * @method checkInvoiceStatusByParams(array $params)
 * @method cronCheckInvoiceStatusByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 审核电子发票
     *
     * @param  int $invoice_id 发票ID [Original type uint] [ require true ]
     * @param  bool $pass 是否通过 [ require true ]
     * @param  array $complete_extend 额外自定义信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewElectronicInvoice (int $invoice_id, bool $pass, array $complete_extend = []) {
        return self::getClass()->reviewElectronicInvoice([
            "invoice_id" => $invoice_id,
            "pass" => $pass,
            "complete_extend" => $complete_extend,
        ]);
    }

    /**
     * 开具电子普票
     *
     * @support  string $buyername 购方名称 [ require true ]
     * @support  bool $isNow 是否立即开具电子发票 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $orderno 订单号 [ require true ]
     * @support  string $invoicedate 开票时间 [ require true ]
     * @support  string $clerk 开票员 [ require true ]
     * @support  string $salephone 销方电话 [ require true ]
     * @support  string $saleaddress 销方地址 [ require true ]
     * @support  string $saletaxnum 销方税号 [ require true ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  array $extend 额外自定义信息 
     * @support  int $store_id 开具门店ID [Original type uint] 
     * @support  string $phone 购方手机 (开票成功会短信提醒购方，和邮箱必填至少一个) 
     * @support  string $email 推送邮箱 (开票成功会邮件提醒购方，和手机必填至少一个) 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @support  string $payee 收款人 
     * @support  string $checker 复核人 
     * @support  string $saleaccount 销方银行账号(和开户行合在一起) 
     * @support  string $message 备注信息 
     * @throws  \Exception
     * @return  array
     */
    public static function createElectronicInvoice () {
        return self::getClass()->createElectronicInvoice();
    }

    /**
     * 开具电子普票(简易模式)
     *
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  bool $isNow 是否立即开具电子发票 [ require true ]
     * @support  string $buyername 购方名称 [ require true ]
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $orderno 订单号 [ require true ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  array $extend 额外自定义信息 
     * @support  int $store_id 开具门店ID [Original type uint] 
     * @support  string $saletaxnum 销方税号 
     * @support  string $phone 购方手机 (开票成功会短信提醒购方，和邮箱必填至少一个) 
     * @support  string $email 推送邮箱 (开票成功会邮件提醒购方，和手机必填至少一个) 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @support  string $message 备注信息 
     * @throws  \Exception
     * @return  array
     */
    public static function createSimpleElectronicInvoice () {
        return self::getClass()->createSimpleElectronicInvoice();
    }

    /**
     * 发票冲红
     *
     * @param  int $invoiceId 发票id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reverseInvoice (int $invoiceId) {
        return self::getClass()->reverseInvoice([
            "invoiceId" => $invoiceId,
        ]);
    }

    /**
     * 开具纸质普票(简易模式)
     *
     * @support  string $buyername 购方名称 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $orderno 订单号 [ require true ]
     * @support  array $detail 发票明细 [ require true ]
     * @support  array $extend 额外自定义信息 
     * @support  int $store_id 开具门店ID [Original type uint] 
     * @support  string $delivery_area 收货省市区信息 [ require true ]
     * @support  string $delivery_address 收货详细地址信息 [ require true ]
     * @support  string $delivery_people 收货人 [ require true ]
     * @support  string $delivery_phone 收货手机 [ require true ]
     * @support  string $saletaxnum 销方税号 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @support  string $message 备注信息 
     * @throws  \Exception
     * @return  array
     */
    public static function createSimplePersonalPaperInvoice () {
        return self::getClass()->createSimplePersonalPaperInvoice();
    }

    /**
     * 开具纸质专票(简易模式)
     *
     * @support  string $buyername 购方名称 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  string $taxnum 购方税号(18/20位) [ require true ]
     * @support  string $orderno 订单号 [ require true ]
     * @support  array $detail 发票明细 [ require true ]
     * @support  string $telephone 购方电话 [ require true ]
     * @support  string $address 购方地址 [ require true ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require true ]
     * @support  array $extend 额外自定义信息 
     * @support  int $store_id 开具门店ID [Original type uint] 
     * @support  string $delivery_area 收货省市区信息 [ require true ]
     * @support  string $delivery_address 收货详细地址信息 [ require true ]
     * @support  string $delivery_people 收货人 [ require true ]
     * @support  string $delivery_phone 收货手机 [ require true ]
     * @support  string $saletaxnum 销方税号 
     * @support  string $message 备注信息 
     * @throws  \Exception
     * @return  array
     */
    public static function createSimpleCompanyPaperInvoice () {
        return self::getClass()->createSimpleCompanyPaperInvoice();
    }

    /**
     * 设置纸质开票完成状态(进行邮寄)
     *
     * @param  string $delivery_company 快递公司 [ require true ]
     * @param  string $serviceType 服务类型 [ require true ]
     * @param  int $delivery_id 快递单号 [Original type uint] [ require true ]
     * @param  int $invoice_id 发票ID [Original type uint] [ require true ]
     * @param  array $complete_extend 额外自定义信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deliveryPaperInvoice (int $invoice_id, int $delivery_id, string $delivery_company, string $serviceType = '', array $complete_extend = []) {
        return self::getClass()->deliveryPaperInvoice([
            "invoice_id" => $invoice_id,
            "delivery_id" => $delivery_id,
            "delivery_company" => $delivery_company,
            "serviceType" => $serviceType,
            "complete_extend" => $complete_extend,
        ]);
    }

    /**
     * 获取单个发票信息
     *
     * @param  int $invoice_id 发票ID [Original type uint] [ require true ]
     * @param  bool $include_reverse 是否包含红票信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvokeById (int $invoice_id, bool $include_reverse = false) {
        return self::getClass()->getInvokeById([
            "invoice_id" => $invoice_id,
            "include_reverse" => $include_reverse,
        ]);
    }

    /**
     * 获取多个发票信息
     *
     * @param  array $invoice_ids 发票ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $include_reverse 是否包含红票信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvokesByIds (array $invoice_ids, bool $include_reverse = false) {
        return self::getClass()->getInvokesByIds([
            "invoice_ids" => $invoice_ids,
            "include_reverse" => $include_reverse,
        ]);
    }

    /**
     * 只能删除状态为未开具的发票
     *
     * @param  int $invoice_id 发票ID [Original type uint] [ require true ]
     * @param  array $delete_extend 额外自定义信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteInvoke (int $invoice_id, array $delete_extend = []) {
        return self::getClass()->deleteInvoke([
            "invoice_id" => $invoice_id,
            "delete_extend" => $delete_extend,
        ]);
    }

    /**
     * 强制将发票标为作废（不会开出红票）
     *
     * @param  int $invoice_id 发票ID [Original type uint] [ require true ]
     * @param  array $invalid_extend 额外自定义信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function forceInvalid (int $invoice_id, array $invalid_extend = []) {
        return self::getClass()->forceInvalid([
            "invoice_id" => $invoice_id,
            "invalid_extend" => $invalid_extend,
        ]);
    }

    /**
     * 获取没开过发票的订单
     *
     * @param  array $orderIds 订单IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllowOrderInvokes (array $orderIds) {
        return self::getClass()->getAllowOrderInvokes([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 发票列表查询
     *
     * @param  string $serviceType 服务类型 [ require true ]
     * @param  bool $isElectronic 是否是电子发票 [ require true ]
     * @param  array $orderIds 订单IDs [ require true ]
     * @param  string $orderId 订单ID(前缀模糊查询) [ require true ]
     * @param  int $storeId 开具门店ID [Original type uint] [ require true ]
     * @param  string $invokeType 发票类型 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  array $statusIn 状态s [ require true ]
     * @param  string $title 抬头(前缀模糊查询) [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvokesList (string $serviceType, bool $isElectronic, string $invokeType = '', string $startTime = '', string $endTime = '', string $status = '', array $orderIds = [], int $storeId = 0, string $title = '', int $page = 1, int $pageSize = 15, array $statusIn = [], string $orderId = '') {
        return self::getClass()->getInvokesList([
            "serviceType" => $serviceType,
            "isElectronic" => $isElectronic,
            "invokeType" => $invokeType,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "status" => $status,
            "orderIds" => $orderIds,
            "storeId" => $storeId,
            "title" => $title,
            "page" => $page,
            "pageSize" => $pageSize,
            "statusIn" => $statusIn,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 检查开票是否成功
     *
     * @param  int $invoiceId 发票ID [Original type uint] [ require true ]
     * @param  bool $isReverse 是否红票 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkInvoiceStatus (int $invoiceId, bool $isReverse = false) {
        return self::getClass()->checkInvoiceStatus([
            "invoiceId" => $invoiceId,
            "isReverse" => $isReverse,
        ]);
    }

    /**
     * 每5分钟检查过去1天内的电子发票状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCheckInvoiceStatus () {
        return self::getClass()->cronCheckInvoiceStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}