<?php
namespace Mainto\Bridge\Invokes\PaymentGetway;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreMerchantListByParams(array $params)
 * @method getInfoByPaymentNoByParams(array $params)
 */
class Bill {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询门店绑定商户列表
     *
     * @param  array $types 商户类型 [Original type array&lt;string&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreMerchantList (array $types = []) {
        return self::getClass()->getStoreMerchantList([
            "types" => $types,
        ]);
    }

    /**
     * 获取流水详情
     *
     * @param  string $paymentNo 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoByPaymentNo (string $paymentNo) {
        return self::getClass()->getInfoByPaymentNo([
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('PaymentGetway', 'Bill');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('PaymentGetway', 'Bill');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}